//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Visualization_AssetAccessor_h)
#define Courier_Visualization_AssetAccessor_h

#include <Courier/Base.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetId.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetValidation.h>

namespace Candera {
    class DefaultAssetProvider;
    class ContentLoader;
    class AssetConfig;
}

namespace Courier {
    class AssetConfiguration;
}

namespace Courier {
    namespace Internal {
        struct AssetLibHelper {
            ///
            static Int GetCount(const Candera::DefaultAssetProvider* assetProvider, Candera::AssetLib assetLib);
        };
    }
/// @addtogroup COURIER_VISUALIZATION
/// @{
/** AssetAccessor allows accessing the asset data before ViewHandler is loading the asset.
    ViewHandler uses instance of AssetAccessor. 
*/
class AssetAccessor
{
    public:
        /// DisplayData may be used for detecting the display configuration for the startup phase.
        struct DisplayData {
            DisplayData() : mDisplayId(-1), mDisplayName(0), mWidth(-1), mHeight(-1) {}
            ///
            Int mDisplayId;
            ///
            const Char * mDisplayName;
            ///
            Int mWidth;
            ///
            Int mHeight;
        };

        ///
        AssetAccessor();

        ///
        virtual ~AssetAccessor();

        /// Returns an instance to the AssetAccessor.
        static AssetAccessor & GetInstance();

        /// Frees resources.
        void Finalize();

        /** Initializes the AssetAccessor.
            @param assetConfiguration AssetConfiguration used by the AssetAccessor.
            @param validationFlags Validation flags for validating asset content during asset loading. Default flags are CffVersionAttribute|FractionalNumberRepresentationAttribute|PlatformInstanceNameAttribute.
            @return <em>true</em> if initialization was successful,
                    <em>false</em> otherwise. */
        bool Init(Candera::AssetConfig * assetConfiguration, UInt32 validationFlags = Candera::AssetValidation::DefaultValidationFlags());

        /// Returns the display count.
        Int GetDisplayCount() const;

        /** Returns the DisplayData based on the index.
            @param idx the used index, must be smaller then the returned display count.
            @param displayData output parameter.
            @return <em>true</em> if the display data is valid,
                    <em>false</em> otherwise. */
        bool GetDisplayData(Int idx, AssetAccessor::DisplayData & displayData);

        /// Returns the DefaultAssetProvider. Used also by the ViewHandler.
        Candera::DefaultAssetProvider * GetDefaultAssetProvider() { return mAssetProvider; }

        /// Returns the ContentLoader. Used also by the ViewHandler.
        Candera::ContentLoader * GetContentLoader() { return mContentLoader; }

    private:
        FEATSTD_MAKE_CLASS_UNCOPYABLE(AssetAccessor);

        /// used AssetConfiguration
        Candera::AssetConfig * mAssetConfiguration;

        /// ContentLoader used by the AssetAccessor
        Candera::ContentLoader * mContentLoader;

        /// DefaultAssetProvider used by the AssetAccessor.
        Candera::DefaultAssetProvider * mAssetProvider;
};

/// @}
}

#endif
