//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <Courier/Util/StaticObjectBuffer.h>

namespace Courier {
    namespace Internal {
        COURIER_LOG_SET_REALM(Courier::Diagnostics::LogRealm::Messaging);
        namespace StaticObjectBuffer_Private {

            void* StaticObjectBufferBase::AllocBase(const Internal::StaticObjectBuffer_Private::BufferData* mBufferData, void* (*AccessRawObject)(void* data, UInt32 index), RawObjectBase::MarkType& (*GetMark)(void* data), void* (*GetObject)(void* data))
            {

                FEATSTD_DEBUG_ASSERT(CountBase(mBufferData, AccessRawObject, GetMark) <= CapacityBase(mBufferData));
                if (CountBase(mBufferData, AccessRawObject, GetMark) >= CapacityBase(mBufferData)) { // Robustness: ">=" instead of "=="
                    return 0;
                }

                void* lpRawObject = 0;
                for (UInt32 i = 0; i < CapacityBase(mBufferData); ++i) {
                    if (GetMark(GetRawObjectBase(i, mBufferData, AccessRawObject)) == RawObjectBase::cMarkFree) {
                        lpRawObject = GetRawObjectBase(i, mBufferData, AccessRawObject);
                        break;
                    }
                }

                FEATSTD_DEBUG_ASSERT(lpRawObject != 0);
                FEATSTD_DEBUG_ASSERT(GetMark(lpRawObject) == RawObjectBase::cMarkFree);
                GetMark(lpRawObject) = RawObjectBase::cMarkUsed;

                FEATSTD_DEBUG_ASSERT(reinterpret_cast<FeatStd::SizeType>(lpRawObject) ==
                    ((reinterpret_cast<FeatStd::SizeType>(lpRawObject) + SIZE_OF_VOID_PTR - 1) / SIZE_OF_VOID_PTR) * SIZE_OF_VOID_PTR);

                FEATSTD_DEBUG_ASSERT(reinterpret_cast<FeatStd::SizeType>(GetObject(lpRawObject)) ==
                    (((reinterpret_cast<FeatStd::SizeType>(GetObject(lpRawObject)) +  + SIZE_OF_VOID_PTR - 1) / SIZE_OF_VOID_PTR) * SIZE_OF_VOID_PTR));
                FEATSTD_DEBUG_ASSERT(RawObjectBase::IsUsed(GetObject(lpRawObject)));
                return GetObject(lpRawObject);
            }

            void StaticObjectBufferBase::FreeBase(void* object, const Internal::StaticObjectBuffer_Private::BufferData* mBufferData, void* (*AccessRawObject)(void* data, UInt32 index), RawObjectBase::MarkType& (*GetMark)(void* data))
            {
                FEATSTD_DEBUG_ASSERT(object != 0);
                if (object == 0) {
                    return; // Robustness
                }

                FEATSTD_DEBUG_ASSERT(RawObjectBase::IsUsed(object));
                UInt8*const lpRawObjAddr = FeatStd::Internal::PointerToPointer<UInt8*>(object) - sizeof(RawObjectBase::MarkType);
                FEATSTD_DEBUG_ASSERT(lpRawObjAddr >= GetRawObjectBase(0, mBufferData, AccessRawObject));
                FEATSTD_LINT_NEXT_EXPRESSION(946, "Relational or subtract operator applied to pointers [MISRA C++ Rule 5-0-15], [MISRA C++ Rule 5-0-17], [MISRA C++ Rule 5-0-18]: comparing addresses was intended")
                if (lpRawObjAddr < GetRawObjectBase(0, mBufferData, AccessRawObject)) {
                    return; // Robustness
                }
                FEATSTD_DEBUG_ASSERT(lpRawObjAddr < GetRawObjectBase(CapacityBase(mBufferData), mBufferData, AccessRawObject));
                FEATSTD_LINT_NEXT_EXPRESSION(946, "Relational or subtract operator applied to pointers [MISRA C++ Rule 5-0-15], [MISRA C++ Rule 5-0-17], [MISRA C++ Rule 5-0-18]: comparing addresses was intended")
                if (lpRawObjAddr >= GetRawObjectBase(CapacityBase(mBufferData), mBufferData, AccessRawObject)) {
                    return; // Robustness
                }

                FEATSTD_DEBUG_ASSERT(GetMark(lpRawObjAddr) == RawObjectBase::cMarkUsed);
                if (GetMark(lpRawObjAddr) != RawObjectBase::cMarkUsed) {
                    return; // Robustness
                }

                FEATSTD_DEBUG_ASSERT(RawObjectBase::IsUsed(object));
                GetMark(lpRawObjAddr) = RawObjectBase::cMarkFree;
                FEATSTD_DEBUG_ASSERT(!RawObjectBase::IsUsed(object));
            }

            UInt32 StaticObjectBufferBase::CountBase(const Internal::StaticObjectBuffer_Private::BufferData* mBufferData, void* (*AccessRawObject)(void* data, UInt32 index), RawObjectBase::MarkType& (*GetMark)(void* data))
            {
                UInt32 lUsed = 0;
                for (UInt32 i = 0; i < CapacityBase(mBufferData); ++i) {
                    if (GetMark(GetRawObjectBase(i, mBufferData, AccessRawObject)) != RawObjectBase::cMarkFree) {
                        FEATSTD_DEBUG_ASSERT(GetMark(GetRawObjectBase(i, mBufferData, AccessRawObject)) == RawObjectBase::cMarkUsed);
                        lUsed++;
                    }
                }
                return lUsed;
            }

            UInt32 StaticObjectBufferBase::CapacityBase(const Internal::StaticObjectBuffer_Private::BufferData* mBufferData)
            {
                // Disabled due to SCHostLib generation COURIER_DEBUG_ASSERT(mBufferData != 0);
                if (mBufferData == 0) {
                    // TODO: find replacement for this error report
                    COURIER_LOG_FATAL("Buffer not configured!");
                    return 0; // Just for SCHostLib generation!
                }

                FEATSTD_DEBUG_ASSERT(mBufferData->mSize > 0);
                return mBufferData->mSize;
            }

            void* StaticObjectBufferBase::GetRawObjectBase(UInt32 index, const Internal::StaticObjectBuffer_Private::BufferData* mBufferData, void* (*AccessRawObject)(void* data, UInt32 index))
            {
                FEATSTD_DEBUG_ASSERT(index < (CapacityBase(mBufferData) + 1)); // TODO

                FEATSTD_DEBUG_ASSERT(mBufferData != 0);
                FEATSTD_DEBUG_ASSERT(mBufferData->mDataPtr != 0);
                return AccessRawObject(mBufferData->mDataPtr, index);
            }

            void StaticObjectBufferBase::InitBufferDataBase(const Internal::StaticObjectBuffer_Private::BufferData*& mBufferData, const Internal::StaticObjectBuffer_Private::BufferData* bufferData)
            {
                FEATSTD_DEBUG_ASSERT(bufferData != 0);

                FEATSTD_DEBUG_ASSERT(mBufferData == 0);
                mBufferData = bufferData;
            }

        }
    }
}
