//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "TransitionStringBufferAppenders.h"

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {

    template<> UInt32 FeatStd::StringBufferAppender<Candera::Transitions::Identifier>::Append(FeatStd::StringBuffer & stringBuffer, Candera::Transitions::Identifier const & object)
    {
        UInt32 tcharCount = 0;
        tcharCount += stringBuffer.Append(Candera::Transitions::TransitionTraceMapper::MapIdentifierToString(object));
        return tcharCount;
    }

    template<> UInt32 FeatStd::StringBufferAppender<Candera::Transitions::Hint>::Append(FeatStd::StringBuffer & stringBuffer, Candera::Transitions::Hint const & object)
    {
        UInt32 tcharCount = 0;
        tcharCount += stringBuffer.Append(Candera::Transitions::TransitionTraceMapper::MapHintToString(object));
        return tcharCount;
    }

    template<> UInt32 FeatStd::StringBufferAppender<Candera::Transitions::TransitionFragment>::Append(FeatStd::StringBuffer & stringBuffer, Candera::Transitions::TransitionFragment const & object)
    {
        UInt32 tcharCount = 0;
        if (!object.GetTrigger().PointsToNull()) {
            Candera::Transitions::RequestFragment::SharedPointer requestFragment = object.GetTrigger()->GetRequest();
            if (!requestFragment.PointsToNull()) {
                tcharCount += stringBuffer.Append(Candera::Transitions::TransitionTraceMapper::MapRequestFragmentTypeToString(requestFragment->GetType()));
                tcharCount += stringBuffer.Append(Candera::Transitions::TransitionTraceMapper::MapIdentifierToString(requestFragment->GetIdentifier()));
                tcharCount += stringBuffer.Append(Candera::Transitions::TransitionTraceMapper::MapHintToString(requestFragment->GetHint()));
            }
        }
        return tcharCount;
    }

    template<> UInt32 FeatStd::StringBufferAppender<Candera::Transitions::Transition>::Append(FeatStd::StringBuffer & stringBuffer, Candera::Transitions::Transition const & object)
    {
        UInt32 tcharCount = 0;
        Candera::Transitions::TransitionFragment::SharedPointer next = object.GetFirstFragment();
        while(!next.PointsToNull()) {
            tcharCount += stringBuffer.AppendObject(next.GetSharedInstance());
            next = next->GetNext();
        }
        return tcharCount;
    }
}
#endif
