//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Platform_Visualization_Impl_RendererHelper_h)
#define Courier_Platform_Visualization_Impl_RendererHelper_h

#include <Courier/Platform/Base.h>
#include <Courier/Visualization/Gdu.h>

namespace Courier {

#if ! defined(COURIER_DEFAULT_LAYER_COUNT)
    static const Int cCOURIER_DEFAULT_LAYER_COUNT = 8;
#define COURIER_DEFAULT_LAYER_COUNT Courier::cCOURIER_DEFAULT_LAYER_COUNT
#else
    static const Int cCOURIER_DEFAULT_LAYER_COUNT = COURIER_DEFAULT_LAYER_COUNT;
#endif

#if ! defined(COURIER_DEFAULT_DISPLAY_COUNT)
    static const Int cCOURIER_DEFAULT_DISPLAY_COUNT = 4;
#define COURIER_DEFAULT_DISPLAY_COUNT Courier::cCOURIER_DEFAULT_DISPLAY_COUNT
#else
    static const Int cCOURIER_DEFAULT_DISPLAY_COUNT = COURIER_DEFAULT_DISPLAY_COUNT;
#endif
}

namespace Courier { namespace Internal {
/// @addtogroup COURIER_VISUALIZATION
/// @{
/**
 * RendererHelper class provides a platform abstraction for different handling Courier Gdu Upload and Unload.
 */
class RendererHelper
{
public:

    /** Performs a platform dependent upload of the render target.
    @param lookupGdu - the render target to be uploaded;
    @param renderer - pointer to Courier renderer;
    @param forceEnable - bool flag for enabling unloading of the current render target, if it uses the same layerId as the lookupGdu;
    @return <em>true</em> if Upload method was called on the lookupGdu,
    <em>false</em> otherwise ( this can simply state that the lookupGdu is already uploaded and a new call on Upload method was not performed). */
    static bool PlatformUpload(Gdu* lookupGdu, Courier::Renderer* renderer, bool forceEnable);

    /** Performs a platform dependent unload of the render target.
    @param lookupGdu - the render target to be unloaded;
    @param renderer - pointer to Courier renderer;
    @return <em>true</em> if Unload method was called on the lookupGdu,
    <em>false</em> otherwise ( this can simply state that the ref count for lookupGdu is > 0 and a call on Unload method was not performed). */
    static bool PlatformUnload(Gdu* lookupGdu, Courier::Renderer* renderer);

    /// Makes the cleanup of variables used for Uploading/Unloading.
    static void PlatformClean();

private:
    FEATSTD_MAKE_CLASS_STATIC(RendererHelper);
};

/// @}
}}
#endif //Courier_Platform_Visualization_Impl_RendererHelper_h
