//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Platform_MessageFactory_h)
#define Courier_Platform_MessageFactory_h

#include <Courier/Platform/Base.h>

#include <Courier/Diagnostics/Log.h>
#include <FeatStd/Diagnostics/ErrorHandling.h>
#include <FeatStd/Diagnostics/CodeChecks.h>

#include <Courier/Messaging/Message.h>

#include COURIER_PLATFORM_INCLUDE(MessageFactory)

using Courier::Message;

namespace Courier { namespace Platform {
/// @addtogroup COURIER_PLATFORM
/// @{
/**
 * This class provides a typesafe mechanism to create/delete Courier message instances.
 * The implementation is inherited from (a platform dependent) base class implementation.<br>
 * Allocate/Free handles only memory management (provided by base class),
 * Create/Destroy handles CTOR/DTOR calls also.
 * @see StaticMessageFactory, DynamicMessageFactory
 * @remark MessageFactory isn't a factory in the sense of GoF-Patterns.
 */
class MessageFactory : private Impl::MessageFactory
{
    typedef Impl::MessageFactory Base;

    COURIER_LOG_SET_REALM(Diagnostics::LogRealm::Platform);

public:
    /// Creates an instance of MsgType (Memory allocation plus CTOR call).
    template<typename MsgType>
    static MsgType* Create() {
        void* lpMemory = Allocate<MsgType>();

        // Ensure MsgType is subtype of Message
        Message* lpMessage = new (lpMemory) MsgType();
        return static_cast<MsgType*>(lpMessage);
    }

    template<typename MsgType, typename ArgType1>
    static MsgType* Create(ArgType1 arg1) {
        void* lpMemory = Allocate<MsgType>();

        // Ensure MsgType is subtype of Message
        Message* lpMessage = new (lpMemory) MsgType(arg1);
        return static_cast<MsgType*>(lpMessage);
    }

    template<typename MsgType, typename ArgType1, typename ArgType2>
    static MsgType* Create(ArgType1 arg1, ArgType2 arg2) {
        void* lpMemory = Allocate<MsgType>();

        // Ensure MsgType is subtype of Message
        Message* lpMessage = new (lpMemory) MsgType(arg1, arg2);
        return static_cast<MsgType*>(lpMessage);
    }

    template<typename MsgType, typename ArgType1, typename ArgType2, typename ArgType3>
    static MsgType* Create(ArgType1 arg1, ArgType2 arg2, ArgType3 arg3) {
        void* lpMemory = Allocate<MsgType>();

        // Ensure MsgType is subtype of Message
        Message* lpMessage = new (lpMemory) MsgType(arg1, arg2, arg3);
        return static_cast<MsgType*>(lpMessage);
    }

    template<typename MsgType, typename ArgType1, typename ArgType2, typename ArgType3, typename ArgType4>
    static MsgType* Create(ArgType1 arg1, ArgType2 arg2, ArgType3 arg3, ArgType4 arg4) {
        void* lpMemory = Allocate<MsgType>();

        // Ensure MsgType is subtype of Message
        Message* lpMessage = new (lpMemory) MsgType(arg1, arg2, arg3, arg4);
        return static_cast<MsgType*>(lpMessage);
    }

    template<typename MsgType, typename ArgType1, typename ArgType2, typename ArgType3, typename ArgType4, typename ArgType5>
    static MsgType* Create(ArgType1 arg1, ArgType2 arg2, ArgType3 arg3, ArgType4 arg4, ArgType5 arg5) {
        void* lpMemory = Allocate<MsgType>();

        // Ensure MsgType is subtype of Message
        Message* lpMessage = new (lpMemory) MsgType(arg1, arg2, arg3, arg4, arg5);
        return static_cast<MsgType*>(lpMessage);
    }

    template<typename MsgType, typename ArgType1, typename ArgType2, typename ArgType3, typename ArgType4, typename ArgType5,
             typename ArgType6 >
    static MsgType* Create(ArgType1 arg1, ArgType2 arg2, ArgType3 arg3, ArgType4 arg4, ArgType5 arg5,
                           ArgType6 arg6) {
        void* lpMemory = Allocate<MsgType>();

        // Ensure MsgType is subtype of Message
        Message* lpMessage = new (lpMemory) MsgType(arg1, arg2, arg3, arg4, arg5, arg6);
        return static_cast<MsgType*>(lpMessage);
    }

    template<typename MsgType, typename ArgType1, typename ArgType2, typename ArgType3, typename ArgType4, typename ArgType5,
             typename ArgType6, typename ArgType7 >
    static MsgType* Create(ArgType1 arg1, ArgType2 arg2, ArgType3 arg3, ArgType4 arg4, ArgType5 arg5,
                           ArgType6 arg6, ArgType7 arg7) {
        void* lpMemory = Allocate<MsgType>();

        // Ensure MsgType is subtype of Message
        Message* lpMessage = new (lpMemory) MsgType(arg1, arg2, arg3, arg4, arg5, arg6, arg7);
        return static_cast<MsgType*>(lpMessage);
    }

    template<typename MsgType, typename ArgType1, typename ArgType2, typename ArgType3, typename ArgType4, typename ArgType5,
             typename ArgType6, typename ArgType7, typename ArgType8 >
    static MsgType* Create(ArgType1 arg1, ArgType2 arg2, ArgType3 arg3, ArgType4 arg4, ArgType5 arg5,
                           ArgType6 arg6, ArgType7 arg7, ArgType8 arg8) {
        void* lpMemory = Allocate<MsgType>();

        // Ensure MsgType is subtype of Message
        Message* lpMessage = new (lpMemory) MsgType(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
        return static_cast<MsgType*>(lpMessage);
    }

    template<typename MsgType, typename ArgType1, typename ArgType2, typename ArgType3, typename ArgType4, typename ArgType5,
             typename ArgType6, typename ArgType7, typename ArgType8, typename ArgType9 >
    static MsgType* Create(ArgType1 arg1, ArgType2 arg2, ArgType3 arg3, ArgType4 arg4, ArgType5 arg5,
                           ArgType6 arg6, ArgType7 arg7, ArgType8 arg8, ArgType9 arg9) {
        void* lpMemory = Allocate<MsgType>();

        // Ensure MsgType is subtype of Message
        Message* lpMessage = new (lpMemory) MsgType(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
        return static_cast<MsgType*>(lpMessage);
    }

    template<typename MsgType, typename ArgType1, typename ArgType2, typename ArgType3, typename ArgType4, typename ArgType5,
             typename ArgType6, typename ArgType7, typename ArgType8, typename ArgType9, typename ArgType10 >
    static MsgType* Create(ArgType1 arg1, ArgType2 arg2, ArgType3 arg3, ArgType4 arg4, ArgType5 arg5,
                           ArgType6 arg6, ArgType7 arg7, ArgType8 arg8, ArgType9 arg9, ArgType10 arg10) {
        void* lpMemory = Allocate<MsgType>();

        // Ensure MsgType is subtype of Message
        Message* lpMessage = new (lpMemory) MsgType(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
        return static_cast<MsgType*>(lpMessage);
    }

    /// Allocates memory for a MsgType instance.
    template<typename MsgType>
    static void* Allocate() {
        void* lpMemory = Base::Allocate<MsgType>();
        if (lpMemory == 0) {
            COURIER_LOG_ERROR("Message (ID: 0x%08X) not allocated!", MsgType::ID);
            if(ShallPanic()) {
                FEATSTD_PANIC("Insufficient memory");
            }
        }
        return lpMemory;
    }

    /// Deletes the instance message (DTOR call plus memory deallocation).
    static void Destroy(Message* message) {
        FEATSTD_GUARD(message != 0) {

        message->~Message();

        Free(message);
    }
    }

    /// Frees  memory allocated for the corresponding MsgType instance.
    static void Free(void* ptr) { Base::Free(ptr); }

    /// Enables or disables if FEATSTD_PANIC shall be thrown if a message could not be allocated (default = disabled).
    static void EnablePanic(bool enable = true) { mPanicEnabled = enable; }

    /// Returns if FEATSTD_PANIC shall be called after an unsuccessful allocation attempt.
    static bool ShallPanic() { return mPanicEnabled; }

private:
    FEATSTD_MAKE_CLASS_STATIC(MessageFactory);

    static bool mPanicEnabled;
   
};
/// @}
}}

/// @addtogroup COURIER_PLATFORM
/// @{
/**
 * Alternative possibility to create message instances.
 * According to COURIER_NEW and COURIER_xxx_NEW.
 */
#define COURIER_MESSAGE_NEW(type) Courier::Platform::MessageFactory::Create<type>
/// @}
#endif
