//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "MessageReferrer.h"
#include "Message.h"

namespace Courier { 
    // ------------------------------------------------------------------------
    MessageReferrer::MessageReferrer(Message * msg) : mMsg(msg)
    {
        if (mMsg != 0) {
            mMsg->IncRef();
        }
    }

    // ------------------------------------------------------------------------
    MessageReferrer::MessageReferrer(const MessageReferrer & msgRef) : mMsg(0)
    {
        *this = msgRef;
    }

    // ------------------------------------------------------------------------
    MessageReferrer & MessageReferrer::operator =(const MessageReferrer & msgRef)
    {
        // Check for self-assignment
        if (this != &msgRef) {
            // Decrement reference counter of current linked message
            if (mMsg != 0) {
                mMsg->DecRef();
            }

            // Link new message object to (this) referrer
            mMsg = msgRef.mMsg;     //lint !e1555   // Direct pointer copy of member 'mMsg' within copy assignment operator: 'operator=(const MessageReferrer &)'

            // Increment reference counter of new linked message object
            if (mMsg != 0)  {
                mMsg->IncRef();
            }
        }
        return *this;
    }

    // ------------------------------------------------------------------------
    MessageReferrer::~MessageReferrer()
    {
        if (mMsg != 0) {
            mMsg->DecRef();
            mMsg = 0;
        }
    }

    /*  ------------------------------------------------------------------------
        operator ==
        ------------------------------------------------------------------------ */
    bool MessageReferrer::operator ==(const MessageReferrer & msgRef) const
    {
        return (msgRef.mMsg == mMsg);
    }

    // ------------------------------------------------------------------------
    ConstMessageReferrer::ConstMessageReferrer(const Message *msg) : MessageReferrer(const_cast<Message*>(msg)) 
    {
    }

    // ------------------------------------------------------------------------
    ConstMessageReferrer::ConstMessageReferrer(const ConstMessageReferrer &cRef)  : MessageReferrer(cRef) 
    {
    }
}
