//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Messaging_MessageReceiverPreprocessor_h)
#define Courier_Messaging_MessageReceiverPreprocessor_h

#include <Courier/Base.h>
#include <Courier/Util/LinkedList.h>

namespace Courier {
/// @addtogroup COURIER_MESSAGING
/// @{
/** MessageReceiverPreprocessor is the base class for pre processing purposes, called by the MessageReceiver Preprocess method.
*/
class MessageReceiverPreprocessor 
{
    public:
        /// 
        Internal::LinkedListNode<MessageReceiverPreprocessor> MessageReceiverPreprocessorListNode;
        ///
        MessageReceiverPreprocessor();
        ///
        virtual ~MessageReceiverPreprocessor();

        /** Process has to be implemented. */
        virtual bool Process() = 0;
};

/// @}

}

#endif
