//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(Courier_FoundationMsgs_h)
#define Courier_FoundationMsgs_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
#include <Courier/Serialization/BaseSerializer.h>
#endif
#include <Courier/Messaging/Message.h>
#include <Courier/Foundation/FoundationTypes.h>

namespace Courier {
/// @addtogroup COURIER_FOUNDATION
/// @{
/** The position of the pointing device. */
typedef Int32 XYDIM;
/** The id of the pointer, e.g in case multitouch events the id of a finger, in case of a mouse event it will be 0. */
typedef UInt8  PointerId;
typedef UInt32  SourceId;
typedef UInt32  TouchTimeStamp;

/** The key code. */
typedef UInt8  KeyCode;
typedef UInt16 KeyCode16;
/// @}
// ------------------------------------------------------------------------
/// @addtogroup COURIER_FOUNDATION
/// @{
/** Send the StartupMsg to signal the comonents that the message processing has been started. */
class StartupMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(StartupMsg, ::Courier::Message, 0xBA074335);

        StartupMsg();
        virtual ~StartupMsg();

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mStartupMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mStartupMsgModifiableMetadata;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_FOUNDATION
/// @{
/** Send the ShutdownMsg to signal the component to prepare for exit the application. */
class ShutdownMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ShutdownMsg, ::Courier::Message, 0xA60CB9F4);

        ShutdownMsg();
        virtual ~ShutdownMsg();

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mShutdownMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mShutdownMsgModifiableMetadata;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_FOUNDATION
/// @{
            /** TouchMsg which may be used for TouchHandling. 
            * - State: maybe Down, Move and Up state.
            * - XPos,YPos: the position coordinates.
            * - PointerId: the identifier of the pointer, in case of multi touch, the number of the finger.
            * - SourceId: in case the more then one sources (e.g. displays) the number of the display.
            * - TimeStamp: the time at which the touch occurred (the time unit depends on the TouchMsg emitter).
            */
class TouchMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TouchMsg, ::Courier::Message, 0xE60BDECC);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(5);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        TouchMsg();
        TouchMsg(TouchMsgState::Enum const & aState, XYDIM const & aXPos, XYDIM const & aYPos, TouchTimeStamp const & aTimeStamp, PointerId const & aPointerId = static_cast< ::Courier::PointerId > ( 0 ), SourceId const & aSourceId = 0);
        virtual ~TouchMsg();

        TouchMsgState::Enum const & GetState() const { return mState; }
        void SetState(TouchMsgState::Enum const & value) { mState = value; }
        XYDIM const & GetXPos() const { return mXPos; }
        void SetXPos(XYDIM const & value) { mXPos = value; }
        XYDIM const & GetYPos() const { return mYPos; }
        void SetYPos(XYDIM const & value) { mYPos = value; }
        TouchTimeStamp const & GetTimeStamp() const { return mTimeStamp; }
        void SetTimeStamp(TouchTimeStamp const & value) { mTimeStamp = value; }
        PointerId const & GetPointerId() const { return mPointerId; }
        void SetPointerId(PointerId const & value) { mPointerId = value; }
        SourceId const & GetSourceId() const { return mSourceId; }
        void SetSourceId(SourceId const & value) { mSourceId = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTouchMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mTouchMsgModifiableMetadata;
        static ::Courier::ComponentId mTouchMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        TouchMsgState::Enum mState;
        XYDIM mXPos;
        XYDIM mYPos;
        TouchTimeStamp mTimeStamp;
        PointerId mPointerId;
        SourceId mSourceId;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_FOUNDATION
/// @{
/** KeyDownMsg will be posted to handle key presses. */
class KeyDownMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(KeyDownMsg, ::Courier::Message, 0xCFBDECF2);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(5);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        KeyDownMsg();
        KeyDownMsg(KeyCode const & aKeyCode);
        virtual ~KeyDownMsg();

        KeyCode const & GetKeyCode() const { return mKeyCode; }
        void SetKeyCode(KeyCode const & value) { mKeyCode = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mKeyDownMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mKeyDownMsgModifiableMetadata;
        static ::Courier::ComponentId mKeyDownMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        KeyCode mKeyCode;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_FOUNDATION
/// @{
/** KeyMsg will be posted to handle key presses. */
class KeyMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(KeyMsg, ::Courier::Message, 0x984DEB57);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        KeyMsg();
        KeyMsg(KeyCode16 const & aKeyCode, bool const & aKeyState);
        virtual ~KeyMsg();

        KeyCode16 const & GetKeyCode() const { return mKeyCode; }
        void SetKeyCode(KeyCode16 const & value) { mKeyCode = value; }
        bool const & GetKeyState() const { return mKeyState; }
        void SetKeyState(bool const & value) { mKeyState = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mKeyMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mKeyMsgModifiableMetadata;
        static ::Courier::ComponentId mKeyMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        KeyCode16 mKeyCode;
        bool mKeyState;
};

/// @}
} // namespace Courier
#endif // Courier_FoundationMsgs_h
