//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ExtCommInputHandler.h"

#include <Courier/Diagnostics/Log.h>
#include <Courier/Messaging/Message.h>

namespace Courier {

    COURIER_LOG_SET_REALM(Courier::Diagnostics::LogRealm::Foundation);

    // ------------------------------------------------------------------------
    bool ExtCommInputHandler::Post(Message * msg)
    {
        FEATSTD_DEBUG_ASSERT(0 != msg);
        bool lRc = (0 != msg);
        if (lRc) {
            COURIER_LOG_DEBUG("Post incoming %s", msg->GetName());
            lRc = msg->Post();
            if (!lRc) {
                COURIER_LOG_ERROR("Post incoming %s failed!", msg->GetName());
            }
        }

        return (lRc);
    }
}
