//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Foundation_ExtCommComponent_h)
#define Courier_Foundation_ExtCommComponent_h

#include <Courier/Foundation/Component.h>
#include <Courier/Foundation/ExtCommInputHandler.h>

// Forward declarations
namespace Courier {
    class IExtCommOutputHandler;
}

namespace Courier {
    /// @addtogroup COURIER_FOUNDATION
    /// @{
    /**
     * Converts external (platform dependent) messages into Courier messages.
     * Courier messages can be either Courier framework messages (e.g. ExternalMsgs.h) or
     * application specific messages (derived from Courier::Message).
     * Processes Courier messages mainly by converting it into external
     * (platform dependent) messages.
     */
    class ExtCommComponent : public Courier::Component
    {
        typedef Courier::Component Base;

    //! [COURIER_ExtCommComponent_Interface]
    public:
        /** Constructor of external communication component, which expects a unique component ID.
            @param cid Component ID. */
        ExtCommComponent(ComponentId cid);

        ///
        virtual ~ExtCommComponent();

        /** Attaches the given external input handler to the external communication component.
            @param extCommInputHandler External input handler to attach. */
        void Attach(ExtCommInputHandler * extCommInputHandler);

        /** Detaches the given external input handler from the external communication component.
            @param extCommInputHandler External input handler to detach. */
        void Detach(ExtCommInputHandler * extCommInputHandler);

        /** Links an external output handler to the external communication component.
            @param extCommOutputHandler External output handler to link. */
        IExtCommOutputHandler * SetExtCommOutputHandler(IExtCommOutputHandler * extCommOutputHandler);
    //! [COURIER_ExtCommComponent_Interface]

    protected:
        ///
        virtual bool OnMessage(const Courier::Message & msg);

        ///
        virtual bool OnExecute();

    private:
        /// Linked list type for component list
        typedef Internal::LinkedList<ExtCommInputHandler, &ExtCommInputHandler::ExtCommInputHandlerListNode> ExtCommInputHandlerList;

        ///
        ExtCommInputHandlerList mExtCommInputHandlerList;

        ///
        IExtCommOutputHandler * mExtCommOutputHandler;
    };
    /// @}
}
#endif
