//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ExtCommComponent.h"

#include <Courier/Diagnostics/Log.h>
#include <Courier/Foundation/IExtCommOutputHandler.h>
#include <Courier/Messaging/Message.h>

namespace Courier {

    // ------------------------------------------------------------------------
    ExtCommComponent::ExtCommComponent(ComponentId cid) : Component(cid), mExtCommOutputHandler(0)
    {
    }

    // ------------------------------------------------------------------------
    ExtCommComponent::~ExtCommComponent()
    {
        mExtCommOutputHandler = 0;
    }

    // ------------------------------------------------------------------------
    void ExtCommComponent::Attach(ExtCommInputHandler * extCommInputHandler)
    {
        FEATSTD_DEBUG_ASSERT(0 != extCommInputHandler);
        if (0 != extCommInputHandler) {
            mExtCommInputHandlerList.Prepend(extCommInputHandler);
        }
        // Immediately enable continuous execution (means listening to attached input handlers)
        EnableContinuousExecution(true);
    }

    // ------------------------------------------------------------------------
    void ExtCommComponent::Detach(ExtCommInputHandler * extCommInputHandler)
    {
        FEATSTD_DEBUG_ASSERT(0 != extCommInputHandler);
        if (0 != extCommInputHandler) {
            (void)mExtCommInputHandlerList.Remove(extCommInputHandler);
        }
    }

    // ------------------------------------------------------------------------
    IExtCommOutputHandler * ExtCommComponent::SetExtCommOutputHandler(IExtCommOutputHandler * extCommOutputHandler)
    {
        IExtCommOutputHandler * lPrevExtCommOutputHandler = mExtCommOutputHandler;
        mExtCommOutputHandler = extCommOutputHandler;
        return lPrevExtCommOutputHandler;
    }

    // ------------------------------------------------------------------------
    bool ExtCommComponent::OnMessage(const Message & msg)
    {
        bool lRc = msg.IsExternal();
        if (lRc && (0 != mExtCommOutputHandler)) {
            // Forward the message to the output handler
            lRc = mExtCommOutputHandler->OnMessage(msg);
        } else {
            lRc = false;
        }

        return lRc;
    }

    // ------------------------------------------------------------------------
    bool ExtCommComponent::OnExecute()
    {
        // Listen from all attached external input handlers
        for (ExtCommInputHandlerList::Iterator it = mExtCommInputHandlerList.Begin(); it != mExtCommInputHandlerList.End(); ++it) {
            ExtCommInputHandler * lInputHandler = &*it;
            // Trigger listen method on every thread loop cycle
            lInputHandler->Listen();
        }

        // Trigger on every loop cycle, only if at least one input handler is attached
        return (mExtCommInputHandlerList.GetSize() > 0);
    }
}
