//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Foundation_ComponentType_h)
#define Courier_Foundation_ComponentType_h

#if !defined(COURIER_COMPONENT_MAX_COUNT)
#define COURIER_COMPONENT_MAX_COUNT 32U
#endif

#if !defined(COURIER_PROCESS_MAX_COUNT)
#define COURIER_PROCESS_MAX_COUNT 7U
#endif

#include <Courier/Base.h>
#include <FeatStd/Util/FeatLimits.h>

#ifndef COURIER_COMPONENT_CUSTOM_TYPES
#define COURIER_COMPONENT_CUSTOM_TYPES
#endif

namespace Courier {
    /// Type for component ID
    typedef FeatStd::Internal::TaylorUnsignedIntType<
        (1U << (FeatStd::Internal::BitsNeeded<COURIER_COMPONENT_MAX_COUNT-1>::result
        + FeatStd::Internal::BitsNeeded<COURIER_PROCESS_MAX_COUNT>::result)) - 1>::Type ComponentId;

    namespace ComponentType {
    /// @addtogroup COURIER_FOUNDATION
    /// @{
    /** Descriptive type for component IDs. */
        enum Enum {
            ///
            Controller = 0,
            ///
            Model,
            ///
            View,
            ///
            ExternalCommunicator,
            ///
            Renderer,
            ///
            Renderer2D,
            ///
            Renderer3D,
            ///
            Ipc,

            /// Defines the first component ID value, that can be used for customer specific components
            CustomerFirst,
            COURIER_COMPONENT_CUSTOM_TYPES

            /// Defines the last component ID value, that can be used for customer specific components
            CustomerLast = (COURIER_COMPONENT_MAX_COUNT - 1),

            ///
            Invalid = FeatStd::Internal::NativeTypeLimit<ComponentId>::cMaxValue
        };
    /// @}
    }
}

#endif // Courier_Foundation_ComponentType_h
