//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Diagnostics_Trace_h)
#define Courier_Diagnostics_Trace_h

#include <Courier/Base.h>

#include <Courier/Diagnostics/TraceControl.h>
#include <FeatStd/Diagnostics/LocationInfo.h>

#include <Courier/Diagnostics/TraceIds.h>

/// @addtogroup COURIER_DIAGNOSTICS
/// @{
#if defined(COURIER_TRACE_MESSAGE)
    #error Should not be defined; Uses default implementation in Trace.h
#endif

/**
 * Outputs a TRACE message.
 * Example: <br>
 *   COURIER_TRACE_MESSAGE(Diagnostics::TId_MessagePosted, lpMessage)
 * @param traceId Id of trace location
 * @param courierMessage Pointer to Courier message being processed
 *
 * @see TraceIds.h
 */
FEATSTD_LINT_MACRO_WHILEFALSE(COURIER_TRACE_MESSAGE)
#define COURIER_TRACE_MESSAGE(traceId, courierMessage) \
    do { \
        if (Courier::Diagnostics::TraceControl::IsEnabled()) { \
            FeatStd::Diagnostics::LocationInfo lInfo(__FILE__, __LINE__, FEATSTD_LOG_FUNC); \
            Courier::Diagnostics::TraceControl::Forced_Message(traceId, \
                                                               courierMessage, \
                                                               lInfo); \
        } \
    FEATSTD_SUPPRESS_MSC_WARNING_FOR_NEXT_EXPRESSION(4127, while (false) accepted) \
    } while (false)
/// @}
#endif
