//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Diagnostics_LogRealm_h)
#define Courier_Diagnostics_LogRealm_h

#include <FeatStd/Diagnostics/Log.h>
#ifndef FEATSTD_LOG_ENABLED
    #error LOG mechanism files should not be included
#endif

#define COURIER_LOG_DECLARE_REALM(LogRealm) FEATSTD_LOG_DECLARE_REALM(LogRealm)
#define COURIER_LOG_DEFINE_REALM(LogRealm)  FEATSTD_LOG_DEFINE_REALM(LogRealm)

#include <Courier/Base.h>

#ifdef COURIER_ENHANCED_ENABLED
    #include <Candera/System/Diagnostics/Log.h>
#endif

namespace Courier { namespace Diagnostics { namespace LogRealm {
/// @addtogroup COURIER_DIAGNOSTICS
/// @{
FEATSTD_LINT_NEXT_EXPRESSION(578, "hides Courier::Platform - intended hiding")
FEATSTD_LOG_DECLARE_REALM(Platform);
FEATSTD_LOG_DECLARE_REALM(Messaging);
#ifdef COURIER_ENHANCED_ENABLED
    FEATSTD_LOG_DECLARE_REALM(Visualization);
    FEATSTD_LOG_DECLARE_REALM(DataBinding);
#endif
FEATSTD_LOG_DECLARE_REALM(Foundation);

void LoggerIterationInitialization();
/// @}
}}}
#endif
