//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "TypeConverter.h"

#include <Courier/Diagnostics/Log.h>

namespace Courier {
    // ------------------------------------------------------------------------
    TypeConverterBase::TypeConverterBase(const TypeConverterVtbl &vtbl) : mNext(0), mVtblRef(vtbl)
    {
        (void) Internal::DataBinding::TypeConverterRegistrar::Enlist(this);
    }

    // ------------------------------------------------------------------------
    TypeConverterBase::~TypeConverterBase()
    {
        (void) Internal::DataBinding::TypeConverterRegistrar::Delist(this);
        mNext = 0;
    }

    // ------------------------------------------------------------------------
    bool TypeConverterBase::Check(const DataItemValue &dst, const DataItemValue &src,
        DataItemTypeId typeIdT1, DataItemTypeId typeIdT2)
    {
        return dst.IsMutable() &&
            (((dst.TypeId() == typeIdT1) && (src.TypeId() == typeIdT2)) ||
            ((dst.TypeId() == typeIdT2) && (src.TypeId() == typeIdT1)));
    }

    namespace Internal {
        namespace DataBinding {
            bool SortPredicate(const TypeConverterBase &l, const TypeConverterBase &r);
            typedef Internal::SortedObjectListFunc<TypeConverterBase, SortPredicate> List;

            TypeConverterBase *gHead = 0;

            // ------------------------------------------------------------------------
            bool SortPredicate(const TypeConverterBase &l, const TypeConverterBase &r)
            {
                FEATSTD_LINT_NEXT_EXPRESSION(923, "the cast from void pointer to long is required here")
                    FEATSTD_LINT_NEXT_EXPRESSION(925, "the cast to void pointer is required here")
                    return reinterpret_cast<FeatStd::SizeType>(static_cast<const void*>(l.TypeIdT1())) < reinterpret_cast<FeatStd::SizeType>(static_cast<const void*>(r.TypeIdT2()));
            }

            // ------------------------------------------------------------------------
            bool TypeConverterRegistrar::Enlist(TypeConverterBase *tc)
            {
                return List::Add(gHead, tc);
            }

            // ------------------------------------------------------------------------
            bool TypeConverterRegistrar::Delist(TypeConverterBase *tc)
            {
                return List::Remove(gHead, tc);
            }

            // ------------------------------------------------------------------------
            static inline bool Matches(const TypeConverterBase &tc, DataItemTypeId t1, DataItemTypeId t2)
            {
                return ((tc.TypeIdT1() == t1) && (tc.TypeIdT2() == t2));
            }

            // ------------------------------------------------------------------------
            TypeConverterBase* TypeConverterRegistrar::Locate(DataItemTypeId t1, DataItemTypeId t2)
            {
                TypeConverterBase *tc = gHead;
                while ((tc != 0) && (! Matches(*tc, t1, t2)) && (! Matches(*tc, t2, t1))) {
                    tc = List::NodeAccessor::Next(tc);
                }
                return tc;
            }
        } // namespace DataBinding
    } // namespace Internal
}   // namespace Courier
