//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Internal_ModelBindingTargetHost_h)
#define Courier_Internal_ModelBindingTargetHost_h

namespace Courier { 
    
    /// @addtogroup COURIER_DATABINDING
    /// @{

    namespace Internal {
    
    class Binding;

    /**
     * Interface for binding target hosts. Examples for
     * binding target hosts are e.g. widgets or parameterized
     * localizable texts.
     */
    class ModelBindingTargetHost {
    public:

        /**
         * Adds a binding to this binding target host.
         * @param binding  The binding to add.
         */
        virtual bool Enlist(Binding *binding) = 0;

        /**
         * Removes a binding from this binding target host.
         * @param binding  The binding to remove.
         */
        virtual bool Unlist(Binding *binding) = 0;
    };

} ///@}

}

#endif // !defined(Courier_Internal_ModelBindingTargetHost_h)
