//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <Courier/Diagnostics/Log.h>
#include "MetaInfoUtil.h"

namespace Courier { namespace Internal {

    using namespace Internal::DataBinding;
    using namespace Candera::MetaInfo;

    // ------------------------------------------------------------------------
    const WidgetMetaInfo* GetWidgetMetaInfo(const WidgetPropertyMetaInfo *wpmi)
    {
        using namespace Candera::MetaInfo;

        // get the widget set
        const WidgetSetMetaInfo *wsmi = GetWidgetSet();
        const WidgetMetaInfo *wmiFound = 0;
        if ((wsmi != 0) && (wpmi != 0)) {
            // iterate through all WidgetPropertyMetaInfo objects until the widget owning the property
            // is found (widgetName != 0)
            for (Int32 iWidget = 0; (wmiFound == 0) && (iWidget < wsmi->GetItemCount()); ++iWidget) {
                const WidgetMetaInfo *wmi = wsmi->GetItem(iWidget);
                FEATSTD_DEBUG_ASSERT(wmi != 0);
                if (wmi != 0) {
                    // lookup the property name in the widget
                    const WidgetPropertyMetaInfo *tmpWpmi = wmi->LookupItem(wpmi->GetName());
                    // if a property with the name exist and the WidgetPropertyMetaInfo matches the given one
                    // set widgetName to determine the search
                    if ((tmpWpmi != 0) && (tmpWpmi == wpmi)) {
                        wmiFound = wmi;
                    }
                }
            }
        }
        FEATSTD_DEBUG_ASSERT(wmiFound != 0);
        return wmiFound;
    }

    // ------------------------------------------------------------------------
    const WidgetMetaInfo* GetWidgetMetaInfo(const Char *widgetName)
    {
        FEATSTD_DEBUG_ASSERT(widgetName != 0);
        const WidgetSetMetaInfo *wsmi = GetWidgetSet();
        return ((wsmi != 0) && (widgetName != 0)) ? wsmi->LookupItem(widgetName) : 0;
    }

    // ------------------------------------------------------------------------
    const WidgetPropertyMetaInfo* GetWidgetPropertyMetaInfo(const Char *widgetName, const Char *propertyName)
    {
        FEATSTD_DEBUG_ASSERT((widgetName != 0) && (propertyName != 0));
        const WidgetPropertyMetaInfo *wpmi = 0;
        if ((widgetName != 0) && (propertyName != 0)) {
            const WidgetMetaInfo *wmi = GetWidgetMetaInfo(widgetName);
            if (wmi != 0) {
                wpmi = wmi->LookupItem(propertyName);
            }
        }
        return wpmi;
    }
}}
