//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ListInterfaceBase.h"

namespace Courier {
    // ------------------------------------------------------------------------
    ListInterfaceBase::~ListInterfaceBase()
    {
    }

    // ------------------------------------------------------------------------
    FeatStd::SizeType ListInterfaceBase::FragmentStartIndex() const
    {
        return 0;
    }

    // ------------------------------------------------------------------------
    FeatStd::SizeType ListInterfaceBase::FragmentItemCount() const
    {
        return Count();
    }

    // ------------------------------------------------------------------------
    bool ListInterfaceBase::EndOfList(FeatStd::SizeType index) const
    {
        FeatStd::SizeType count = Count();
        FEATSTD_DEBUG_ASSERT((count != cUnknownQuantity) && (count != cUnboundCount));

        // stability: return true if count is undetermined
        return (index >= count) || (count == cUnknownQuantity) || (count == cUnboundCount);
    }
}
