//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <Courier/Diagnostics/Log.h>
#include "ListEventNotifier.h"

namespace Courier {

COURIER_LOG_SET_REALM(Courier::Diagnostics::LogRealm::DataBinding);

    using namespace Internal;
    using namespace Internal::DataBinding;

    // ------------------------------------------------------------------------
    bool ListEventNotifier::PostMsg(ListEventType::Enum eventType, FeatStd::SizeType newIndex, FeatStd::SizeType oldIndex) const
    {
        ListEventMsg *msg;
        msg = COURIER_MESSAGE_NEW(ListEventMsg)(mItemKey,
                                                BindingSourceRevisionStore::GetRevision(mItemKey),
                                                eventType,
                                                newIndex,
                                                oldIndex);
        bool ok = (msg != 0) && msg->Post();

        if (!ok) {
            COURIER_LOG_ERROR("failed to post ListEventMsg");
        }
        return ok;
    }

    // ------------------------------------------------------------------------
    bool ListEventNotifier::Notify(ListEventType::Enum eventType, FeatStd::SizeType newIndex, FeatStd::SizeType oldIndex) const
    {
        FEATSTD_DEBUG_ASSERT((eventType == ListEventType::AddedItem) ||
                             (eventType == ListEventType::ItemCountChanged) ||
                             (eventType == ListEventType::ListCleared) ||
                             (eventType == ListEventType::ModifiedItem) ||
                             (eventType == ListEventType::MovedItem) ||
                             (eventType == ListEventType::NewFragment) ||
                             (eventType == ListEventType::RefreshList) ||
                             (eventType == ListEventType::RemovedItem));
        bool ok = (eventType != ListEventType::None) && (eventType != ListEventType::RequestedItem) &&
                  PostMsg(eventType, newIndex, oldIndex);
        return ok;
    }
}   // namespace

