//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ListEventHandler.h"

namespace Courier {  

    // ------------------------------------------------------------------------ 
    ListEvent::ListEvent(ListEventType::Enum eventType) :
                mEventType(eventType),
                mNewIndex(ListInterfaceBase::InvalidListIndex()),
                mOldIndex(ListInterfaceBase::InvalidListIndex())
    {
    }

    // ------------------------------------------------------------------------ 
    ListEvent::ListEvent(ListEventType::Enum eventType, FeatStd::SizeType newIndex, FeatStd::SizeType oldIndex) :
                mEventType(eventType),
                mNewIndex(newIndex),
                mOldIndex(oldIndex)
    {
    }

    // ------------------------------------------------------------------------ 
    ListEvent::ListEvent(ListEventType::Enum eventType, FeatStd::SizeType newIndex, FeatStd::SizeType oldIndex, const DataItemValue &value) :
                mEventType(eventType),
                mNewIndex(newIndex),
                mOldIndex(oldIndex),
                mItemValue(value)
    {
    }

    // ======================================================================== 

    // ------------------------------------------------------------------------ 
    ListEventHandler::ListEventHandler() : mCallback(0), mCallbackObject(0)
    {
    }

    // ------------------------------------------------------------------------ 
    void ListEventHandler::InternalSetEventCallback(void *object, Callback CallbackFn)
    {
        if ((object != 0) && (CallbackFn != 0)) {
            mCallbackObject = object;
            mCallback = CallbackFn;
        }
        else {
            mCallbackObject = 0;
            mCallback = 0;
        }
    }

    // ------------------------------------------------------------------------ 
    void ListEventHandler::ResetEventCallback()
    {
        mCallbackObject = 0;
        mCallback = 0;
    }

    // ------------------------------------------------------------------------ 
    void ListEventHandler::operator()(const ListEvent &listEvent) 
    {
        if ((mCallbackObject != 0) && (mCallback != 0)) {
            FEATSTD_LINT_NEXT_EXPRESSION(925, "this cast is required")
            (reinterpret_cast<ListEventHandler*>(mCallbackObject)->*mCallback)(listEvent);
        }
    }

}
