//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Infrastructure.h"

#include <Courier/Diagnostics/Log.h>

namespace Courier { namespace Internal {
    // ------------------------------------------------------------------------
    bool InitDataBinding()
    {
        return Internal::DataBinding::gInfrastructure->Init();
    }
}}

namespace Courier { namespace Internal { namespace DataBinding {
    // ------------------------------------------------------------------------
    static bool DummyInit()
    {
        return true;
    }

    static const DataItemDescriptor cInvalidItemDesc = {
        FEATSTD_LINT_CURRENT_SCOPE(446, "Macros return existing value and do not alter it, no side effect")
        COURIER_INVALID_DATA_ITEM_TYPE_ID(),
        FEATSTD_LINT_CURRENT_SCOPE(923, "Violates MISRA C++ 2008 Required Rule 5-2-8: this cast is required")
        COURIER_NULL_ITEM_MEMBER()
    };

    static const DataItemHierarchyNode cInvalidHierarchyNode = {
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(Identifier::cInvalidHashValue, <invalid>),
        /* mFlags              */ UInt8(DataItemHierarchyNodeFlags::Invalid),
        /* mBindingSourceIndex */ 0,
        /* mParentIndex        */ 0,
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 0,
        /* mItemKey            */ 0
    };

    static const DataItemHierarchyNode *cInvalidDataItemHierarchyNodePtr = &cInvalidHierarchyNode;
    static const BindingSourceRootStorage cInvalidBindingSourceRoot = { 1, &cInvalidHierarchyNode };

    const DataBindingInfrastructure cDefaultInfrastructure = {
        1, &cInvalidDataItemHierarchyNodePtr,
        1, &cInvalidBindingSourceRoot,
        1, &cInvalidItemDesc,
        &DummyInit
    };

    typedef void(*TypeId)(DataItemValue &dst, const DataItemValue &src);

    template<typename T> struct IdentityProvider {
        static const TypeId mIdent;
    };

    template<typename T> void Assign(DataItemValue &dst, const DataItemValue &src);
    template<typename T> const TypeId IdentityProvider<T>::mIdent = &Assign<T>;

    template<typename T> void Assign(DataItemValue &dst, const DataItemValue &src)
    {
        *dst.GetMutableValue<T>() = *src.GetValue<T>();
    }

    // ------------------------------------------------------------------------
    const DataItemHierarchyNode& DataBindingInfrastructure::Node(BindingSourceIndex bsIndex, HierarchyNodeIndex nodeIndex) const
    {
        bool ok = (bsIndex < mBindingSourceCount) && (nodeIndex < mBindingSourceNodes[bsIndex].mNodeCount);
        FEATSTD_DEBUG_ASSERT(ok);
        return ok ? mBindingSourceNodes[bsIndex].mNodes[nodeIndex] : *mGlobalNodeList[0];
    }
}}}
