//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "DataItemValue.h"

namespace Courier {

    // ------------------------------------------------------------------------
    DataItemValue::DataItemValue() : mIsMutable(false), mDataPtr(0), mTypeId(InvalidDataItemType::Ident())
    {
    }

    // ------------------------------------------------------------------------
    DataItemValue::DataItemValue(DataItemTypeId typeId, const void *item) :
        mIsMutable(false),
        FEATSTD_LINT_NEXT_EXPRESSION(925, "this cast is required")
        mDataPtr(const_cast<void*>(item)),
        mTypeId(typeId)
    {
    }

    // ------------------------------------------------------------------------
    void DataItemValue::InternalInit(const void *item, bool isMutable, DataItemTypeId typeId)
    {
        Reset();

        mTypeId = typeId;
        mIsMutable = isMutable;
        FEATSTD_LINT_NEXT_EXPRESSION(925, "this cast is required")
        mDataPtr = const_cast<void*>(item);  // constness maintained by mIsMutable
    }

    // ------------------------------------------------------------------------
    void DataItemValue::Reset()
    {
        mDataPtr = 0;
        mTypeId = InvalidDataItemType::Ident();
    }

    // ------------------------------------------------------------------------
    bool DataItemValue::SetValue(const DataItemValue & value) const
    {
        bool ok = IsValid() &&
                  value.IsValid() &&
                  IsMutable() &&
                  (TypeId() == value.TypeId());
        if (ok) {
            mTypeId->Assign(*this, value);
        }
        return ok;
    }
}   // namespace

