//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_DataBinding_DataContextItem_h)
#define Courier_DataBinding_DataContextItem_h

#include <Courier/DataBinding/DataItemType.h>
#include <Courier/DataBinding/DataItemValue.h>
#include <FeatStd/MemoryManagement/SharedPointer.h>

namespace Courier {
    namespace Internal {
        struct DataContextItemAccess;
    }

    class DataContextItem
    {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(DataContextItem);
        DataContextItem() { }
        DataContextItem(const DataContextItem&) { }
        DataContextItem& operator=(const DataContextItem&) { return *this; }

    private:
        friend struct Internal::DataContextItemAccess;

        virtual DataItemValue AsDataItemValue()
        {
            return DataItemValue(this, true);
        }

        virtual SharedPointer Clone() const
        {
            return SharedPointer();
        }

        FEATSTD_SHARED_POINTER_DECLARATION();
    };

    namespace Internal {
        struct DataContextItemAccess
        {
            static DataItemValue AsDataItemValue(DataContextItem& item)
            {
                return item.AsDataItemValue();
            }

            static DataContextItem::SharedPointer Clone(const DataContextItem::SharedPointer& item)
            {
                if (item.PointsToNull()) {
                    return DataContextItem::SharedPointer();
                }
                return item->Clone();
            }
        };
    }
    //@}
}   // namespace

#endif // Courier_DataBinding_DataContextItem_h
