//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(Courier_DataBindingTypes_h)
#define Courier_DataBindingTypes_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <FeatStd/Util/StringBuffer.h>

namespace Courier {
namespace ListEventType {
// =========================================================================
/// @addtogroup COURIER_DATABINDING
/// @{
/**
 * <summary>Types of list events.</summary>
 */
enum Enum {
    /**
     * nothing happened, no worries
     */
    None = 0,
    /**
     * An item has been added to the list.
     * \par
     * ListEvent initialization (see Courier::ListEvent):
     * - NewIndex - the index of the added item
     * - OldIndex - no meaning (Courier::ListInterfaceBase::cInvalidListIndex)
     * - Item - may contain the new list item. If the value object is invalid, the item must
     * be requested from the list.
     */
    AddedItem = 1,
    /**
     * an item has been changed in the list
     * \par
     * ListEvent initialization (see Courier::ListEvent):
     * - NewIndex - the index of the modified item
     * - OldIndex - no meaning (Courier::ListInterfaceBase::cInvalidListIndex)
     * - Item - may contain the modified list item. If the value object is invalid, the item must
     * be requested from the list.
     */
    ModifiedItem = 2,
    /**
     * Alias for ModifiedItem
     */
    ChangedItem = ModifiedItem,
    /**
     * an item has been removed from the list
     * \par
     * ListEvent initialization (see Courier::ListEvent):
     * - NewIndex - the index of the deleted item
     * - OldIndex - no meaning (Courier::ListInterfaceBase::cInvalidListIndex)
     * - Item - no meaning.
     */
    RemovedItem = 3,
    /**
     * an item has been moved within the list
     * \par
     * ListEvent initialization (see Courier::ListEvent):
     * - NewIndex - the new index of the moved item
     * - OldIndex - the previous index of the item
     * - Item - no meaning (invalid).
     */
    MovedItem = 4,
    /**
     * response to a request for an item. Note that the order list items are sent
     * is not defined.
     * \par
     * ListEvent initialization (see Courier::ListEvent):
     * - NewIndex - index of the requested item
     * - OldIndex - no meaning (Courier::ListInterfaceBase::cInvalidListIndex)
     * - Item - DataItemValue of the requested item.
     */
    RequestedItem = 5,
    /**
     * Multiple changes happend to the list and all list content shall be refreshed
     * \par
     * ListEvent initialization (see Courier::ListEvent):
     * - NewIndex - no meaning (Courier::ListInterfaceBase::cInvalidListIndex)
     * - OldIndex - no meaning (Courier::ListInterfaceBase::cInvalidListIndex)
     * - Item - no meaning (invalid).
     */
    RefreshList = 6,
    /**
     * The number of items in the list has changed.
     * This change is not related to add / remove operations of list items. The number of items in
     * lists may increase over time as the list gets intialized (eg. reading asynchronsously MP3 files
     * from external storage medium). The list will report these changes in the item count with a
     * ItemCountChanged event. The item count change does not affect the previously existing item elements.
     * \par
     * ListEvent initialization (see Courier::ListEvent):
     * - NewIndex - the new number of items in the list or ListInterfaceBase::cUnknownQuantity
     * if the item count could not be retrieved
     * - OldIndex - no meaning (Courier::ListInterfaceBase::cInvalidListIndex)
     * - Item - no meaning (invalid).
     */
    ItemCountChanged = 7,
    /**
     * in case of a fragmented list, this event indicates that a new fragment was received.
     * The list items itself did not change, the list client just received a new set of
     * data. This event might also occure on response to a request for a specific list
     * item (as ListEventType::RequestedItem)
     * \par
     * ListEvent initialization (see Courier::ListEvent):
     * - NewIndex - start index of the fragment
     * - OldIndex - end index of the fragment
     * - Item - no meaning (invalid).
     */
    NewFragment = 8,
    /**
     * All items in the list got deleted.
     * \par
     * ListEvent initialization (see Courier::ListEvent):
     * - NewIndex - no meaning (Courier::ListInterfaceBase::cInvalidListIndex)
     * - OldIndex - no meaning (Courier::ListInterfaceBase::cInvalidListIndex)
     * - Item - no meaning (invalid).
     */
    ListCleared = 9
};
/// @}
} // namespace ListEventType
} // namespace Courier
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
    template<> ::FeatStd::UInt32 StringBufferAppender< ::Courier::ListEventType::Enum >::Append(::FeatStd::StringBuffer& stringBuffer, ::Courier::ListEventType::Enum const & object);
} // namespace FeatStd
#endif
#endif // Courier_DataBindingTypes_h
