//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(Courier_Internal_DataBindingMsgs_h)
#define Courier_Internal_DataBindingMsgs_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
#include <Courier/Serialization/BaseSerializer.h>
#endif
#include <Courier/Messaging/Message.h>
#include <Courier/DataBinding/DataBindingTypes.h>
#include <Courier/DataBinding/DataItemAccessor.h>
#include <Courier/DataBinding/DataItemValue.h>
#include <Courier/DataBinding/ListEventHandler.h>
#include <Courier/Platform/MessageFactory.h>

namespace Courier {
namespace Internal {
// ------------------------------------------------------------------------
/// @addtogroup COURIER_DATABINDING
/// @{
// disable lint warnings for code generated DataBinding message classes
FEATSTD_LINT_MESSAGE_STRING(1516, "*'Courier::Internal::DataBindingMsgBase*", "Intended hiding of base class member")

/** Base class of all DataBinding related messages. */
class DataBindingMsgBase : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DataBindingMsgBase, ::Courier::Message, 0xE898C393);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(3);

        DataBindingMsgBase();
        virtual ~DataBindingMsgBase();

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDataBindingMsgBaseMetaData;
        static ::Courier::Message::ModifiableMetadata mDataBindingMsgBaseModifiableMetadata;
        static const ::Courier::ComponentId mDataBindingMsgBaseSubscriberList[];
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_DATABINDING
/// @{
class BindingSourceBaseMsg : public ::Courier::Internal::DataBindingMsgBase
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(BindingSourceBaseMsg, ::Courier::Internal::DataBindingMsgBase, 0xAC4F086D);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(3);

        BindingSourceBaseMsg();
        BindingSourceBaseMsg(DataItemKey const & aItemKey, UInt16 const & aDataRevision);
        virtual ~BindingSourceBaseMsg();

            /** Binding source data item key. All data binding messages are sent in the context of a specific
                binding source. */
        DataItemKey const & GetItemKey() const { return mItemKey; }
        void SetItemKey(DataItemKey const & value) { mItemKey = value; }
            /** Binding source data revision. The data revision specifies on which revision of data the
                message has been sent. */
        UInt16 const & GetDataRevision() const { return mDataRevision; }
        void SetDataRevision(UInt16 const & value) { mDataRevision = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mBindingSourceBaseMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mBindingSourceBaseMsgModifiableMetadata;
        static const ::Courier::ComponentId mBindingSourceBaseMsgSubscriberList[];

        DataItemKey mItemKey;
        UInt16 mDataRevision;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_DATABINDING
/// @{
            /** message triggers release of all DataItem message references kept in the component binding sources. */
class ReleaseDataItemMsgBase : public ::Courier::Internal::DataBindingMsgBase
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ReleaseDataItemMsgBase, ::Courier::Internal::DataBindingMsgBase, 0x6152E692);

        ReleaseDataItemMsgBase();
        virtual ~ReleaseDataItemMsgBase();

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mReleaseDataItemMsgBaseMetaData;
        static ::Courier::Message::ModifiableMetadata mReleaseDataItemMsgBaseModifiableMetadata;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_DATABINDING
/// @{
          /** Base class of the actual messages carrying data from the model to the other components. All data from model
              to components is sent with DataItem messages. A data item message contains all data of the associated binding source
              (except for list which are sent in fragments). Modified bits tell if a specific data item actually has changed. */
class DataItemMsgBase : public ::Courier::Internal::BindingSourceBaseMsg
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DataItemMsgBase, ::Courier::Internal::BindingSourceBaseMsg, 0x262E598F);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(4);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        DataItemMsgBase();
        DataItemMsgBase(DataItemKey const & aItemKey, UInt16 const & aDataRevision);
        virtual ~DataItemMsgBase();

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDataItemMsgBaseMetaData;
        static ::Courier::Message::ModifiableMetadata mDataItemMsgBaseModifiableMetadata;
        static ::Courier::ComponentId mDataItemMsgBaseSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_DATABINDING
/// @{
          /** The message is sent from the model to answer list requests. See Courier::ListEvent for further details. 
              Note that this message does not actually carry any list item data. The data has to be sent prior to
              the event with a corresponding Courier::DataItemMsg. */
class ListEventMsg : public ::Courier::Internal::BindingSourceBaseMsg
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ListEventMsg, ::Courier::Internal::BindingSourceBaseMsg, 0xF8745864);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(4);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        ListEventMsg();
        ListEventMsg(DataItemKey const & aItemKey, UInt16 const & aDataRevision, ListEventType::Enum const & aEventType, FeatStd::SizeType const & aNewIndex, FeatStd::SizeType const & aOldIndex);
        virtual ~ListEventMsg();

        ListEventType::Enum const & GetEventType() const { return mEventType; }
        void SetEventType(ListEventType::Enum const & value) { mEventType = value; }
        FeatStd::SizeType const & GetNewIndex() const { return mNewIndex; }
        void SetNewIndex(FeatStd::SizeType const & value) { mNewIndex = value; }
        FeatStd::SizeType const & GetOldIndex() const { return mOldIndex; }
        void SetOldIndex(FeatStd::SizeType const & value) { mOldIndex = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mListEventMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mListEventMsgModifiableMetadata;
        static ::Courier::ComponentId mListEventMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        ListEventType::Enum mEventType;
        FeatStd::SizeType mNewIndex;
        FeatStd::SizeType mOldIndex;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_DATABINDING
/// @{
          /** generic message to send data change requests to the model component */
class InternalUpdateModelMsg : public ::Courier::Internal::DataBindingMsgBase
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(InternalUpdateModelMsg, ::Courier::Internal::DataBindingMsgBase, 0xADBC7CAD);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        InternalUpdateModelMsg();
        virtual ~InternalUpdateModelMsg();

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mInternalUpdateModelMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mInternalUpdateModelMsgModifiableMetadata;
        static const ::Courier::ComponentId mInternalUpdateModelMsgSubscriberList[];
};

/// @}
} // namespace Internal
} // namespace Courier

#endif // Courier_Internal_DataBindingMsgs_h
