//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_DataBinding_DataBindingFwd_h)
#define Courier_DataBinding_DataBindingFwd_h

#include <Courier/Base.h>

namespace Courier {
    namespace Internal {
        /// @addtogroup COURIER_DATABINDING
        /// @{

        namespace DataBinding {
            namespace Async {
                class AsyncWidgetPropertyBinding;
                class ElementaryBinding;
                class ListBinding;
            }

            class BindablePropertyCapability;
            class DataItemAccessor;
            class ComponentData;
            class TypeConverterRegistrar;
            class DataItemAccessor;
            template<UInt16 bindingSourceCount> class BindingSourceRevisionStoreImpl;
            class ChangeSet;
            class GenericObjectList;

            struct DataItemDescriptor;
            struct DataItemHierarchyNode;
            struct BindingSourceRootStorage;
            struct DataBindingInfrastructure;
            struct DataTypeInfo;

            struct InvalidType;
        }
    }

    namespace Internal {
        class AsyncBinding;
        class AsyncBindingBase;

        class ModelBindingSource;
        class AsyncModelBindingSource;
        class ModelBindingSourceMap;
        class PropertyBindingData;

        class DataBindingMsgBase;
        class DataItemMsgBase;

        class ListEventMsg;
        class InternalUpdateModelMsg;

        struct BindingSourceListAccessor;
        struct WidgetBindingListAccessor;
    }

    namespace UnitTest {
        struct ChangeSetTestAccessor;
        template<typename T> struct DataItemContainerTestAccessor;
    }

    class AsyncListInterface;
    template<typename T> class TypedAsyncListInterface;
    class SharedAsyncListInterface;
    template<typename T> class TypedSharedAsyncListInterface;

    class ListEvent;
    class ListEventHandler;
    class ListInterfaceBase;
    class GenericListPropertyType;
    class SyncListInterface;
    template<typename T> class TypedSyncListInterface;
    class TypeConverterBase;
    class DataItemValue;
    class ListEventNotifier;
    class ListChangeRequest;
    class BindingSourceRevisionStore;

    // messages
    class AbstractDataItemMsg;
    template<typename T> class DataItemMsg;
    class UpdateModelMsg;

    struct TypeConverterVtbl;

    template<typename T> class ListPropertyType;
    template<typename T1, typename T2> class TypeConverter;
    template<typename T> struct DataItemType;
    template<typename T> class DataItemContainer;

    /** a pointer to the types DataTypeInfo acts as data type key */
    typedef const Internal::DataBinding::DataTypeInfo* DataItemTypeId;

    namespace Internal { namespace DataBinding {
        extern const DataBindingInfrastructure cDefaultInfrastructure;
        typedef bool (*DeserializeValueSignature)(const DataItemValue &value, const Char *buf);
    }}

    namespace Internal {
        /** internal intialization function for DataBinding. Will be invoked by Courer::Init */
        extern bool InitDataBinding();
        class ModelBindingTargetHost;
        class Binding;
    }

    //@}
}   // namespace 

#endif // Courier_DataBinding_DataBindingFwd_h
