//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_DataBinding_BindingBase_h)
#define Courier_DataBinding_BindingBase_h

#include <Courier/DataBinding/Binding.h>
#include <Courier/DataBinding/DataBindingFwd.h>
#include <Courier/DataBinding/Infrastructure.h>
#include <Courier/Diagnostics/ContextCheck.h>


namespace Courier { namespace Internal {

    class BindingBase : public Binding {
    public:
        virtual ~BindingBase();

    protected:
        BindingBase();

        ModelBindingTargetHost* GetTargetHost() const {
            COURIER_CHECK_SCOPE_AFFINITY();
            return mTarget;
        }

        virtual Binding* GetBindingTargetHostNext() {
            COURIER_CHECK_SCOPE_AFFINITY();
            return mBindingTargetNext;
        }

        virtual void SetBindingTargetHostNext(Binding* next) {
            COURIER_CHECK_SCOPE_AFFINITY();
            mBindingTargetNext = next;
        }

        bool InternalInit(ModelBindingTargetHost *target);

        COURIER_DEFINE_SCOPE_AFFINITY(ComponentThreadContext<ComponentType::View>);
    private:
        ModelBindingTargetHost *mTarget; ///< the target of the data binding
        Binding *mBindingTargetNext;     ///< linked list node to register binding in the target
    };
}}

#endif // !defined(Courier_DataBinding_BindingBase_h)
