//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_DataBinding_AsyncTextParameterBindingFactory_h)
#define Courier_DataBinding_AsyncTextParameterBindingFactory_h

#include <Courier/DataBinding/DataBindingFwd.h>
#include <Courier/DataBinding/Infrastructure.h>

namespace Candera { namespace Globalization { namespace Internal {
    class ParameterizedLocalizableText;
}}}

namespace Courier { namespace Internal {
class AsyncTextParameterBindingFactory {
    public:
        /**
            <summary>Creates a binding from the specified data item to widget property.</summary>
            <param name="itemKey">The data item key that is the source of the binding.</param>
            <param name="parameterIndex">[in,out] Index of the parameter to bind to.</param>
            <param name="textInstance">[in,out] the concrete widget instance.</param>
            <param name="typeConvert">(optional) specifies if the binding shall use use type conversion.</param>
            <param name="defaultValue">(optional) the default value.</param>
            <returns>true if the binding could be established, false otherwise.</returns>
        */
        bool CreateBinding(DataItemKey itemKey,
                           UInt8 parameterIndex,
                           Candera::Globalization::Internal::ParameterizedLocalizableText *textInstance,
                           bool typeConvert = false,
                           const DataItemValue &defaultValue = DataItemValue()) const;

        static AsyncTextParameterBindingFactory& GetInstance() {
            static AsyncTextParameterBindingFactory factory;
            return factory;
        }
    };
}}

#endif // !defined(Courier_DataBinding_AsyncTextParameterBindingFactory_h)
