//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Courier_h)
#define Courier_Courier_h

#include <Courier/Diagnostics/Diagnostics.h>
#include <Courier/Foundation/Foundation.h>
#include <Courier/Messaging/Messaging.h>
#include <Courier/Platform/Platform.h>

#if defined(COURIER_ENHANCED_ENABLED)
    #include <Courier/DataBinding/DataBinding.h>
    #include <Courier/Visualization/Visualization.h>
#endif

#if defined(COURIER_IPC_ENABLED) || defined(COURIER_MESSAGE_SERIALIZATION_ENABLED)
    #include <Courier/Serialization/Serialization.h>
#endif

#if defined(COURIER_IPC_ENABLED)
    #include <Courier/Ipc/Ipc.h>
#endif

#if defined(COURIER_MONITOR_ENABLED)
#endif

///
namespace Courier {
    /** Initializes the Courier interaction framework.
        @return <em>true</em>   if initialization was successful,
                <em>false</em>  if initialization has failed. */
    extern bool Init();
}
#endif
