//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <Courier/Courier.h>
#include <Courier/Version.h>
#include <Courier/Messaging/MessageRouter.h>
#include <Courier/Diagnostics/ContextCheck.h>

FEATSTD_LINT_NEXT_EXPRESSION(537, "this repeated include file is dependent of the used platform")
#include <FeatStd/Platform/String.h>

namespace Courier {

    COURIER_LOG_SET_REALM(Courier::Diagnostics::LogRealm::Messaging);

    // ------------------------------------------------------------------------
    bool Init()
    {
        COURIER_LOG_INFO("\n\nCGI-COURIER being used: %s\n\n", Courier::GetVersion());

        COURIER_SET_CONTEXT_THREAD_ID_TO_CURRENT(MainContext);

        Internal::MessageRouter::Init();

        bool lRet(true);
#if defined(COURIER_ENHANCED_ENABLED)
        FEATSTD_LINT_NEXT_EXPRESSION(838, Previous lRet is irrelevant)
        lRet = Internal::InitDataBinding();
#endif
        return lRet;
    }
}
