//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERAWIDGET_WIDGETBASE_WIDGETRTTI_H)
    #define CANDERAWIDGET_WIDGETBASE_WIDGETRTTI_H

#include <Candera/System/Rtti/Rtti.h>

namespace FeatStd {
    namespace Internal {
        struct BaseClassRelation;
    }
}
namespace Candera {
    namespace Internal {
        struct MetaInfoExposer;
    }
}

/// @addtogroup WidgetBase
/// @{
/**
 *  Macros for Widget runtime type information (RTTI).
 *  GetTypeId() returns a unique type identifier.
 *  GetTypeName() returns class type name.
 *  Check with IsTypeOf() if the type matches.
 *  The derivation hierarchy is also considered in IsTypeOf().
 */
#define CGI_WIDGET_RTTI_DECLARATION( CLASS, BASECLASS ) \
    friend struct ::FeatStd::Internal::BaseClassRelation; \
    friend struct ::Candera::Internal::MetaInfoExposer; \
    CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1511, *BASECLASS::GetTypeId, CANDERA_LINT_REASON_RTTI) \
    FEATSTD_TYPEDEF_BASE(BASECLASS); \
    static Candera::TypeId GetTypeId(); \
    virtual bool IsTypeOf(Candera::TypeId typeId) const; \
    virtual const Candera::Char* GetTypeName() const

#define CGI_WIDGET_RTTI_DEFINITION( CLASS ) \
    Candera::TypeId CLASS::GetTypeId() { \
        static Candera::Char c = '\0'; \
        return &c; \
    } \
    bool CLASS::IsTypeOf(Candera::TypeId typeId) const { \
        return _FEATSTD_RTTI_GET_TYPE_ID_IMPL(Base); \
    } \
    const Candera::Char* CLASS::GetTypeName() const { \
        return #CLASS; \
    } \
    Candera::MetaInfo::WidgetMetaInfo* CLASS::GetMetaInfoImpl() { \
        return &Candera::Internal::AIR< CMI<true> >::I(); \
    }

/// @}
#endif  // CANDERAWIDGET_WIDGETBASE_WIDGETRTTI_H
