//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "WidgetBase.h"

namespace Candera {
WidgetBase::WidgetBase() :
    m_name(0),
    m_id(0),
    m_stringIdentifier(),
    m_disposerFn(0)
{
}

WidgetBase::~WidgetBase()
{
    m_name = 0;
    m_disposerFn = 0;
}

void WidgetBase::Dispose()
{
    if ((m_disposerFn != 0) && (m_name != 0)) {
        m_disposerFn(const_cast<Char*>(m_name));
    }
    FEATSTD_DELETE(this);
}

void WidgetBase::SetAnimationTimeDispatcher(Animation::AnimationTimeDispatcher::SharedPointer timeDispatcher)
{
    m_animationTimeDispatcher = timeDispatcher;
    OnAnimationTimeDispatcherChanged();
}

TypeId WidgetBase::GetTypeId() {
    static Char c = '\0';
    return &c;
}

bool WidgetBase::IsTypeOf(TypeId typeId) const
{
    return (GetTypeId() == typeId);
}

const Char* WidgetBase::GetTypeName() const
{
    return "WidgetBase";
}

Candera::MetaInfo::WidgetMetaInfo* WidgetBase::GetMetaInfoImpl()
{
    return &Candera::Internal::AIR< CMI<true> >::I();
}
}
