//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_STRING_STRINGDATATYPES_H)
#define CANDERA_STRING_STRINGDATATYPES_H

#include <Candera/Environment.h>

#include <Candera/System/MetaInfo/DataType.h>

#include <FeatStd/Util/String.h>

namespace Candera { namespace MetaInfo {
/// @addtogroup WidgetString
/// @{
/**
 *  Enumeration to differentiate between static (not localizable) and localizable strings.
 */
enum StringDataType {
    StaticString = 0,                   ///< Static string which is not localizable.
    LocalizableString = 1,              ///< Simple localizable string.
    ParameterizedLocalizableString = 2  ///< Parameterized localizable string.
};

/**
    * @brief DataType specialization for String.
    *
    * The string representation of a LocalizableStringData consists of
    *  - StringDataType
    *  - Id
    *  - default text
    *  separated by semicolons, e.g. "1;123;Hello World".
    */
template<> struct DataType<FeatStd::String> {
    static bool ConvertToString(const FeatStd::String& text, Char* buf, UInt bufLen);

    static bool ConvertFromString(FeatStd::String& text, const Char* buf);

    static const Char* GetEditor() { return "custom://StringEditor"; }
};
/// @}
}}
#endif  // CANDERA_STRING_STRINGDATATYPES_H
