//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "TransitionFragment.h"
#include <CanderaTransitions/Trigger.h>

namespace Candera {

using namespace FeatStd;
using namespace Transitions;

FEATSTD_LOG_SET_REALM(Diagnostics::LogRealm::CanderaTransitions);

FEATSTD_RTTI_BASECLASS_DEFINITION(TransitionFragment)

TransitionFragment::TransitionFragment(const Trigger::SharedPointer& trigger, const SharedPointer& additionalFragment) :
m_additionalFragment(additionalFragment),
m_activationStrategy(Hint::Normal),
m_deactivationStrategy(Hint::Normal),
m_requestFragmentType(RequestFragment::Deactivate),
m_finishTime(0.0F),
m_trigger(trigger),
m_isReversed(false),
m_isFinished(false)
{
    /* constructor */
}

}   // namespace Candera
