//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_TRANSITION_EVENTS_H)
#define CANDERA_TRANSITION_EVENTS_H

#include <Candera/EngineBase/Common/EventListener.h>

namespace Candera {
namespace Transitions {

    class Transition;
    class TransitionFragment;

    /// @addtogroup Transition
    /// @{

    /**
        *  Event is fired when a transition has started execution of its fragments.
        */
    class OnStartTransition : public Event
    {
    public:
        FEATSTD_TYPEDEF_BASE(Event);
        FEATSTD_RTTI_DECLARATION();

        explicit OnStartTransition(const MemoryManagement::SharedPointer<Transition>& transition);

        const MemoryManagement::SharedPointer<Transition>& GetTransition() const { return m_transition; }

    protected:
        MemoryManagement::SharedPointer<Transition> m_transition;
    };

    /**
        *  Event is fired when a transition has finished execution of all its fragments.
        */
    class OnFinishTransition : public Event 
    {
    public:
        FEATSTD_TYPEDEF_BASE(Event);
        FEATSTD_RTTI_DECLARATION();
        explicit OnFinishTransition(const MemoryManagement::SharedPointer<Transition>& transition);

        const MemoryManagement::SharedPointer<Transition>& GetTransition() const { return m_transition; }

    protected:
        MemoryManagement::SharedPointer<Transition> m_transition;
    };

    /**
        *  Event is fired when a transition fragment has started execution.
        */
    class OnStartTransitionFragment : public Event
    {
    public:
        FEATSTD_TYPEDEF_BASE(Event);
        FEATSTD_RTTI_DECLARATION();

        explicit OnStartTransitionFragment(const MemoryManagement::SharedPointer<TransitionFragment>& transitionFragment);

        const MemoryManagement::SharedPointer<TransitionFragment>& GetTransitionFragment() const { return m_transitionFragment; }

    protected:
        MemoryManagement::SharedPointer<TransitionFragment> m_transitionFragment;
    };

    /**
    *  Event is fired when a transition fragment is reversible.
    */
    class OnReverseTransitionFragment : public Event
    {
    public:
        FEATSTD_TYPEDEF_BASE(Event);
        FEATSTD_RTTI_DECLARATION();

        explicit OnReverseTransitionFragment(const MemoryManagement::SharedPointer<TransitionFragment>& transitionFragment);

        const MemoryManagement::SharedPointer<TransitionFragment>& GetTransitionFragment() const { return m_transitionFragment; }

    protected:
        MemoryManagement::SharedPointer<TransitionFragment> m_transitionFragment;
    };

    /**
        *  Event is fired when a transition fragment has finished execution.
        */
    class OnFinishTransitionFragment : public Event
    {
    public:
        FEATSTD_TYPEDEF_BASE(Event);
        FEATSTD_RTTI_DECLARATION();

        explicit OnFinishTransitionFragment(const MemoryManagement::SharedPointer<TransitionFragment>& transitionFragment);

        const MemoryManagement::SharedPointer<TransitionFragment>& GetTransitionFragment() const { return m_transitionFragment; }

    protected:
        MemoryManagement::SharedPointer<TransitionFragment> m_transitionFragment;
    };

        /// @}
}   // namespace Transitions
}   // namespace Candera

#endif // CANDERA_TRANSITION_EVENTS_H
