//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "TransitionEvents.h"
#include <CanderaTransitions/Transition.h>

namespace Candera {

    FEATSTD_RTTI_BASECLASS_DEFINITION(Candera::Event)

    using namespace Transitions;

    FEATSTD_RTTI_DEFINITION(Candera::Transitions::OnStartTransition, Event)
    FEATSTD_RTTI_DEFINITION(Candera::Transitions::OnFinishTransition, Event)
    FEATSTD_RTTI_DEFINITION(Candera::Transitions::OnStartTransitionFragment, Event)
    FEATSTD_RTTI_DEFINITION(Candera::Transitions::OnReverseTransitionFragment, Event)
    FEATSTD_RTTI_DEFINITION(Candera::Transitions::OnFinishTransitionFragment, Event)

    OnStartTransition::OnStartTransition(const MemoryManagement::SharedPointer<Transition>& transition) :
        m_transition(transition) {}

    OnFinishTransition::OnFinishTransition(const MemoryManagement::SharedPointer<Transition>& transition) :
        m_transition(transition) {}

    OnStartTransitionFragment::OnStartTransitionFragment(const MemoryManagement::SharedPointer<TransitionFragment>& transitionFragment) : 
        m_transitionFragment(transitionFragment) {}

    OnReverseTransitionFragment::OnReverseTransitionFragment(const MemoryManagement::SharedPointer<TransitionFragment>& transitionFragment) :
        m_transitionFragment(transitionFragment) {}

    OnFinishTransitionFragment::OnFinishTransitionFragment(const MemoryManagement::SharedPointer<TransitionFragment>& transitionFragment) :
        m_transitionFragment(transitionFragment) {}
}   // namespace Candera
