//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "RuleAdder.h"

#include <FeatStd/Util/StaticObject.h>

#include <Candera/System/MemoryManagement/CanderaHeap.h>
#include <CanderaTransitions/TransitionFragmentFactory.h>

namespace Candera {

using namespace Transitions;


static Rule::SharedPointer& LastRule()
{
    FEATSTD_UNSYNCED_STATIC_OBJECT(Rule::SharedPointer, s_lastRule);
    return s_lastRule;
}

static Rule::SharedPointer s_initLastRule = LastRule();

static Rule::Set::SharedPointer& CurrentRuleSet()
{
    FEATSTD_UNSYNCED_STATIC_OBJECT(Rule::Set::SharedPointer, s_currentRuleSet);
    return s_currentRuleSet;
}

static Rule::Set::SharedPointer s_initCurrentRuleSet = CurrentRuleSet();

void Internal::RuleAdder::BeginRuleSet()
{
    FEATSTD_DEBUG_ASSERT(LastRule().PointsToNull());
    FEATSTD_DEBUG_ASSERT(CurrentRuleSet().PointsToNull());
    CurrentRuleSet() = Rule::Set::SharedPointer(CANDERA_NEW(Rule::Set)());
}

void Internal::RuleAdder::AddRule(Identifier source, Identifier destination, Hint hint, const MemoryManagement::SharedPointer<TransitionFragmentFactory>& factory, bool allowReverse, bool isBidirectional)
{
     FEATSTD_DEBUG_ASSERT(!CurrentRuleSet().PointsToNull());
     if (!CurrentRuleSet().PointsToNull()) {
         Rule::SharedPointer rule(CANDERA_NEW(Rule)(source, destination, hint, factory, allowReverse, isBidirectional));
         if (!LastRule().PointsToNull()) {
             LastRule()->m_next = rule;
         }
         else {
             CurrentRuleSet()->m_firstRule = rule;
         }
         LastRule() = rule;
     }
}

Rule::Set::SharedPointer Internal::RuleAdder::EndRuleSet()
{
    FEATSTD_DEBUG_ASSERT(!CurrentRuleSet().PointsToNull());
    Rule::Set::SharedPointer result = CurrentRuleSet();
    CurrentRuleSet() = Rule::Set::SharedPointer();
    LastRule() = Rule::SharedPointer();
    return result;
}

}   // namespace Candera
