//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Hint.h"

namespace Candera {

using namespace Transitions;
using namespace FeatStd;

Hint::Data::Data(const Optional<Float>& fade, const Optional<Vector2>& fadeTimeline, const Optional<Vector3>& slide, const Optional<Vector2>& slideTimeline, bool isSlideRelative, const Optional<Vector3>& scale, const Optional<Vector2>& scaleTimeline, bool isScaleRelative, 
    const Optional<Candera::Id>& animationId, const Optional<Vector2>& animationTimeline, bool isAnimationTimeRelative, const Optional<Hint::FragmentStrategy>& activationStrategy, const Optional<Hint::FragmentStrategy>& deactivationStrategy,
    const Optional<Float>& activationDelay, const Optional<Float>& deactivationDelay, const CustomHint::SharedPointer& customHint) :
    m_fade(fade),
    m_fadeTimeline(fadeTimeline),
    m_slide(slide),
    m_slideTimeline(slideTimeline),
    m_isSlideRelative(isSlideRelative),
    m_scale(scale),
    m_scaleTimeline(scaleTimeline),
    m_isScaleRelative(isScaleRelative),
    m_animationId(animationId),
    m_animationTimeline(animationTimeline),
    m_isAnimationTimeRelative(isAnimationTimeRelative),
    m_activationStrategy(activationStrategy),
    m_deactivationStrategy(deactivationStrategy),
    m_activationDelay(activationDelay),
    m_deactivationDelay(deactivationDelay),
    m_customHint(customHint)
{
}

Hint::Data::Data(const Data& data) :
    m_fade(data.m_fade),
    m_fadeTimeline(data.m_fadeTimeline),
    m_slide(data.m_slide),
    m_slideTimeline(data.m_slideTimeline),
    m_isSlideRelative(data.m_isSlideRelative),
    m_scale(data.m_scale),
    m_scaleTimeline(data.m_scaleTimeline),
    m_isScaleRelative(data.m_isScaleRelative),
    m_animationId(data.m_animationId),
    m_animationTimeline(data.m_animationTimeline),
    m_isAnimationTimeRelative(data.m_isAnimationTimeRelative),
    m_activationStrategy(data.m_activationStrategy),
    m_deactivationStrategy(data.m_deactivationStrategy),
    m_activationDelay(data.m_activationDelay),
    m_deactivationDelay(data.m_deactivationDelay),
    m_customHint(data.m_customHint)
{
}

Hint::Data::Data() :
    m_fade(),
    m_fadeTimeline(),
    m_slide(),
    m_slideTimeline(),
    m_isSlideRelative(true),
    m_scale(),
    m_scaleTimeline(),
    m_isScaleRelative(true),
    m_animationId(),
    m_animationTimeline(),
    m_isAnimationTimeRelative(false),
    m_activationStrategy(Hint::Normal),
    m_deactivationStrategy(Hint::Normal),
    m_activationDelay(0.0F),
    m_deactivationDelay(0.0F),
    m_customHint(0)
{
}

Hint::Hint(const FeatStd::String& name,
    const Optional<Float>& fade, const Optional<Vector2>& fadeTimeline,
    const Optional<Vector3>& slide, const Optional<Vector2>& slideTimeline,
    const Optional<Vector3>& scale, const Optional<Vector2>& scaleTimeline,
    const Optional<Candera::Id>& animationId, const Optional<Vector2>& animationTimeline,
    const CustomHint::SharedPointer& customHint,
    bool isSlideRelative, bool isScaleRelative, bool isAnimationTimeRelative) :
    m_name(name),
    m_details(Data(fade, fadeTimeline, slide, slideTimeline, isSlideRelative, scale, scaleTimeline, isScaleRelative, animationId, animationTimeline, isAnimationTimeRelative,
    Optional<FragmentStrategy>(Hint::Normal), Optional<FragmentStrategy>(Hint::Normal), Optional<Float>(0.0F), Optional<Float>(0.0F), customHint))
{
}

Hint::Hint(const FeatStd::String& name, 
    const Optional<Float>& fade, const Optional<Vector2>& fadeTimeline, 
    const Optional<Vector3>& slide, const Optional<Vector2>& slideTimeline, 
    const Optional<Vector3>& scale, const Optional<Vector2>& scaleTimeline, 
    const Optional<Candera::Id>& animationId, const Optional<Vector2>& animationTimeline,
    const Optional<FragmentStrategy>& activationStrategy,
    const Optional<FragmentStrategy>& deactivationStrategy,
    const Optional<Float>& activationDelay,
    const Optional<Float>& deactivationDelay,
    const CustomHint::SharedPointer& customHint, 
    bool isSlideRelative, bool isScaleRelative, bool isAnimationTimeRelative) :
    m_name(name),
    m_details(Data(fade, fadeTimeline, slide, slideTimeline, isSlideRelative, scale, scaleTimeline, isScaleRelative, animationId, animationTimeline, isAnimationTimeRelative, activationStrategy, deactivationStrategy, activationDelay, deactivationDelay, customHint))
{
}

Hint::Hint(const FeatStd::String& name) :
    m_name(name)
{
}

Hint::Hint(const Hint& hint) :
    m_name(hint.m_name),
    m_details(hint.m_details)
{
}

const Optional<Hint::Data>& Hint::GetDetails() const
{
    return m_details;
}

bool Hint::Data::operator==(const Hint::Data& rhs) const
{
    return (
        (m_fade == rhs.m_fade) &&
        (m_fadeTimeline == rhs.m_fadeTimeline) &&
        (m_slide == rhs.m_slide) &&
        (m_slideTimeline == rhs.m_slideTimeline) &&
        (m_isSlideRelative == rhs.m_isSlideRelative) &&
        (m_scale == rhs.m_scale) &&
        (m_scaleTimeline == rhs.m_scaleTimeline) &&
        (m_isScaleRelative == rhs.m_isScaleRelative) &&
        (m_animationId == rhs.m_animationId) &&
        (m_animationTimeline == rhs.m_animationTimeline) &&
        (m_isAnimationTimeRelative == rhs.m_isAnimationTimeRelative) &&
        (m_activationStrategy == rhs.m_activationStrategy) &&
        (m_deactivationStrategy == rhs.m_deactivationStrategy) &&
        (m_activationDelay == rhs.m_activationDelay) &&
        (m_deactivationDelay == rhs.m_deactivationDelay) &&
        (m_customHint == rhs.m_customHint)
        );
}


}   // namespace Candera
