//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ScriptComponent.h"

namespace Candera {

namespace Scripting {

    FEATSTD_RTTI_BASECLASS_DEFINITION(ScriptComponent)

ScriptComponent::ScriptComponent()
    :
    m_priority(0.0F),
    m_isEnabled(true)
{
}

ScriptComponent::~ScriptComponent()
{
    for (SizeType i = 0; i < m_parameters.Size(); ++i) {
        FEATSTD_DELETE_ARRAY(m_parameters[i].m_name);
        ParameterInfo::Parameter& parameter = m_parameters[i].m_parameter;
        if (String == parameter.m_type) {
            FEATSTD_DELETE_ARRAY(parameter.m_value.m_string);
        }
    }
}

} // namespace Scripting

} // namespace Candera
