//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Script.h"

#include <Candera/System/EntityComponentSystem/EntitySystem.h>
#include <CanderaScripting/ScriptSystem.h>

namespace Candera {

namespace Scripting {

Script::Script(const Char* script, bool isOwner)
    :
    m_script(script),
    m_isOwner(isOwner)
{
}

Script::~Script()
{
    if (m_isOwner) {
        FEATSTD_DELETE_ARRAY(m_script);
    }
}

MemoryManagement::SharedPointer<Script> Script::Create(const Char* script, bool isOwner)
{
    MemoryManagement::SharedPointer<Scripting::Script> scriptObject(FEATSTD_NEW(Scripting::Script)(script, isOwner));
    return scriptObject;
}

void Script::DisposeSelf()
{
    FEATSTD_DELETE(this);
}

bool Script::SetScript(const Char* script, bool isOwner)
{
    if (script == m_script) {
        return true;
    }

    if (m_isOwner) {
        FEATSTD_DELETE_ARRAY(m_script);
    }

    m_script = script;
    m_isOwner = isOwner;
    ScriptSystem* scriptSystem = EntityComponentSystem::EntitySystem::Get<ScriptSystem>();
    if (0 != scriptSystem) {
        return scriptSystem->OnScriptChanged(this);
    }

    return true;
}

} // namespace Scripting

} // namespace Candera
