//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "LinuxPerfCounter.h"

FEATSTD_LINT_FILE(829, ctime, "required access to how resolution timer source")
#include <ctime>

namespace Platform {

    using namespace Candera;

    FEATSTD_LINT_CURRENT_SCOPE(1013, "false positive, tv_sec and tv_nsec are members of timespec")
    FEATSTD_LINT_CURRENT_SCOPE(1960, "Violates MISRA C++ 2008 Required Rule 5-18-1: false positive, comma operator is not used")
    FEATSTD_LINT_CURRENT_SCOPE(774, "Violates MISRA C++ 2008 Required Rule 0-1-2: false positive as wrongly identified as comma operator")
    FEATSTD_LINT_CURRENT_SCOPE(948, "Violates MISRA C++ 2008 Required Rule 0-1-9: false positive as wrongly identified as comma operator")
    
    // ----------------------------------------------------------------------------
    inline UInt32 TimeSpecToUInt32(const ::timespec &ts)
    {
        return static_cast<UInt32>(static_cast<UInt32>(ts.tv_sec * 1000000U) + static_cast<UInt32>(ts.tv_nsec / 1000U)) / CANDERA_PERFCOUNTER_RESOLUTION;
    }

    // ----------------------------------------------------------------------------
    static UInt32 GetTimerVal() 
    {
        static bool init = false;
        static time_t startTimeSec;
        static UInt32 startTime;
        
        FEATSTD_LINT_SYMBOL(550, startTimeSec, "startTimeSec is used subsequently.")
        ::timespec ts;
        if (!init) {            
            if (::clock_gettime(CLOCK_MONOTONIC, &ts) == 0) {
                startTimeSec = ts.tv_sec;
                ts.tv_sec = 0;
                startTime = TimeSpecToUInt32(ts);
                init = true;
            }
        }
        
        if (::clock_gettime(CLOCK_MONOTONIC, &ts) == 0) {
            ts.tv_sec -= startTimeSec;
            return TimeSpecToUInt32(ts) - startTime;
        }

        return 0;
    }
    
    // ----------------------------------------------------------------------------
    UInt32 PerfCounter::Now()
    {
        return GetTimerVal();
    }

    // ----------------------------------------------------------------------------
    UInt32 PerfCounter::ShortDuration(UInt16 start, UInt16 end)
    {
        UInt32 duration;
        if (start <= end) {
            duration = static_cast<UInt32>(end - start);
        }
        else {
            duration = (0x0000ffffU - static_cast<UInt32>(start)) + static_cast<UInt32>(end);
        }
        return duration;
    }




}   // namespace Platform

