//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(GenericPerfData_H)
#define GenericPerfData_H

#include <Candera/Environment.h>

namespace GenericPlatform {
    /**
    * @brief Abstraction layer for performance data methods .
    */
    struct PerfData
    {
        struct WiData
        {
            static const Candera::UInt32 InvalidCount=0xFFFFFFFF;
            Candera::UInt32 kickCount;
            Candera::UInt32 submitCount;
        };

        struct CpuData
        {
            static const Candera::UInt8 InvalidLoad=255;
            static const Candera::UInt32 InvalidWorkTime = Candera::UInt32(~0);
            static const Candera::UInt32 InvalidTotalTime = Candera::UInt32(~0);
            Candera::UInt32 totalTime;
            Candera::UInt32 workTime;
            Candera::UInt8 load;
        };

        struct PerformanceData
        {
            PerfData::WiData wi2D;
            PerfData::WiData wi3D;
            PerfData::CpuData cpu;
        };
    };
}
#endif
