//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CanderaPlatform_Device_Genivi_Target_ILM_WaylandInc_h)
#define CanderaPlatform_Device_Genivi_Target_ILM_WaylandInc_h

// Include wayland headers
#include <wayland-client.h>
#include <wayland-client-protocol.h>
#include <wayland-egl.h>
#include <wayland-util.h>
#include <wayland-version.h>

// Check which wayland versions are officially tested and supported with
// CGI Studio
#if ((WAYLAND_VERSION_MAJOR == 1) && (WAYLAND_VERSION_MINOR == 0))
    #define WAYLAND_VERSION_1_0
#elif ((WAYLAND_VERSION_MAJOR == 1) && (WAYLAND_VERSION_MINOR == 1))
    #define WAYLAND_VERSION_1_1
#elif ((WAYLAND_VERSION_MAJOR == 1) && (WAYLAND_VERSION_MINOR == 3))
    #define WAYLAND_VERSION_1_3
#elif ((WAYLAND_VERSION_MAJOR == 1) && (WAYLAND_VERSION_MINOR == 9))
    #define WAYLAND_VERSION_1_9
#elif ((WAYLAND_VERSION_MAJOR == 1) && (WAYLAND_VERSION_MINOR == 11))
    #define WAYLAND_VERSION_1_11
#elif ((WAYLAND_VERSION_MAJOR == 1) && (WAYLAND_VERSION_MINOR == 13))
    #define WAYLAND_VERSION_1_13
#elif ((WAYLAND_VERSION_MAJOR == 1) && (WAYLAND_VERSION_MINOR == 14))
    #define WAYLAND_VERSION_1_14
#elif ((WAYLAND_VERSION_MAJOR == 1) && (WAYLAND_VERSION_MINOR > 14))
    #include <FeatStd/Util/MacroKit.h>
    #pragma message("Using wayland-"\
        FEATSTD_STRINGIZE(WAYLAND_VERSION_MAJOR) "." \
        FEATSTD_STRINGIZE(WAYLAND_VERSION_MINOR) "." \
        FEATSTD_STRINGIZE(WAYLAND_VERSION_MICRO) "." \
        " WARNING: this version of Wayland was not tested with CGI-Studio. This wayland version is not supported by CGI Studio! Compile and link errors may occur!")
        
#else
    #include <FeatStd/Util/MacroKit.h>
    #pragma message("Using wayland-"\
        FEATSTD_STRINGIZE(WAYLAND_VERSION_MAJOR) "." \
        FEATSTD_STRINGIZE(WAYLAND_VERSION_MINOR) "." \
        FEATSTD_STRINGIZE(WAYLAND_VERSION_MICRO) "." )
    #error "Wayland version is not supported by CGI Studio!"
#endif //((WAYLAND_VERSION_MAJOR == 1) && (WAYLAND_VERSION_MINOR > 14))

#if ((WAYLAND_VERSION_MAJOR == 1) && (WAYLAND_VERSION_MINOR >= 9)) 
    #define WAYLAND_IVI_EXTENSION
#ifdef USE_WESTON_IVI_SHELL
    #include <ivi-application-client-protocol.h>
#endif //#ifdef USE_WESTON_IVI_SHELL
#endif //#if ((WAYLAND_VERSION_MAJOR == 1) && (WAYLAND_VERSION_MINOR > 11)) 

#endif //#if (!defined(CanderaPlatform_Device_Genivi_Target_ILM_WaylandInc_h))
