//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if defined(PACKAGE_DYN_CREATE)

#include <GLES2/gl2.h>

typedef char GLchar;

#define IMPLEMENT_WRAPPER(returnType, glFunc, signature, params) \
    extern "C" returnType __stdcall Internal##glFunc signature; \
    returnType __stdcall Internal##glFunc signature \
{ \
    return glFunc params;\
} \

#define IMPLEMENT_VOID_WRAPPER(glFunc, signature, params) \
    extern "C" void __stdcall Internal##glFunc signature; \
    void __stdcall Internal##glFunc signature \
{ \
    glFunc params;\
} \



    IMPLEMENT_VOID_WRAPPER( glActiveTexture , (GLenum texture),                                                                                                                                                      (texture));

IMPLEMENT_VOID_WRAPPER( glAttachShader , (GLuint program, GLuint shader), (program, shader));
IMPLEMENT_VOID_WRAPPER( glBindAttribLocation , (GLuint program, GLuint index, const GLchar* name), (program, index, name));
IMPLEMENT_VOID_WRAPPER( glBindBuffer , (GLenum target, GLuint buffer), (target, buffer));
IMPLEMENT_VOID_WRAPPER( glBindFramebuffer , (GLenum target, GLuint framebuffer), (target, framebuffer));
IMPLEMENT_VOID_WRAPPER( glBindRenderbuffer , (GLenum target, GLuint renderbuffer), (target, renderbuffer));
IMPLEMENT_VOID_WRAPPER( glBindTexture , (GLenum target, GLuint texture), (target, texture));
IMPLEMENT_VOID_WRAPPER( glBlendColor , (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha), (red, green, blue, alpha));
IMPLEMENT_VOID_WRAPPER( glBlendEquation , (GLenum mode), (mode));
IMPLEMENT_VOID_WRAPPER( glBlendEquationSeparate , (GLenum modeRGB, GLenum modeAlpha), (modeRGB, modeAlpha));
IMPLEMENT_VOID_WRAPPER( glBlendFunc , (GLenum sfactor, GLenum dfactor), (sfactor, dfactor));
IMPLEMENT_VOID_WRAPPER( glBlendFuncSeparate , (GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha), (srcRGB, dstRGB, srcAlpha, dstAlpha));
IMPLEMENT_VOID_WRAPPER( glBufferData , (GLenum target, GLsizeiptr size, const GLvoid* data, GLenum usage), (target, size, data, usage));
IMPLEMENT_VOID_WRAPPER( glBufferSubData , (GLenum target, GLintptr offset, GLsizeiptr size, const GLvoid* data), (target, offset, size, data));
IMPLEMENT_WRAPPER(GLenum , glCheckFramebufferStatus , (GLenum target), (target));
IMPLEMENT_VOID_WRAPPER( glClear , (GLbitfield mask), (mask));
IMPLEMENT_VOID_WRAPPER( glClearColor , (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha), (red, green, blue, alpha));
IMPLEMENT_VOID_WRAPPER( glClearDepthf , (GLclampf depth), (depth));
IMPLEMENT_VOID_WRAPPER( glClearStencil , (GLint s), (s));
IMPLEMENT_VOID_WRAPPER( glColorMask , (GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha), (red, green, blue, alpha));
IMPLEMENT_VOID_WRAPPER( glCompileShader , (GLuint shader), (shader));
IMPLEMENT_VOID_WRAPPER( glCompressedTexImage2D , (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid* data), (target, level, internalformat, width, height, border, imageSize, data));
IMPLEMENT_VOID_WRAPPER( glCompressedTexSubImage2D , (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid* data), (target, level, xoffset, yoffset, width, height, format, imageSize, data));
IMPLEMENT_VOID_WRAPPER( glCopyTexImage2D , (GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border), (target, level, internalformat, x, y, width, height, border));
IMPLEMENT_VOID_WRAPPER( glCopyTexSubImage2D , (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height), (target, level, xoffset, yoffset, x, y, width, height));
IMPLEMENT_WRAPPER(GLuint , glCreateProgram , (void), ());
IMPLEMENT_WRAPPER(GLuint , glCreateShader , (GLenum type), (type));
IMPLEMENT_VOID_WRAPPER( glCullFace , (GLenum mode), (mode));
IMPLEMENT_VOID_WRAPPER( glDeleteBuffers , (GLsizei n, const GLuint* buffers), (n, buffers));
IMPLEMENT_VOID_WRAPPER( glDeleteFramebuffers , (GLsizei n, const GLuint* framebuffers), (n, framebuffers));
IMPLEMENT_VOID_WRAPPER( glDeleteProgram , (GLuint program), (program));
IMPLEMENT_VOID_WRAPPER( glDeleteRenderbuffers , (GLsizei n, const GLuint* renderbuffers), (n, renderbuffers));
IMPLEMENT_VOID_WRAPPER( glDeleteShader , (GLuint shader), (shader));
IMPLEMENT_VOID_WRAPPER( glDeleteTextures , (GLsizei n, const GLuint* textures), (n, textures));
IMPLEMENT_VOID_WRAPPER( glDepthFunc , (GLenum func), (func));
IMPLEMENT_VOID_WRAPPER( glDepthMask , (GLboolean flag), (flag));
IMPLEMENT_VOID_WRAPPER( glDepthRangef , (GLclampf zNear, GLclampf zFar), (zNear, zFar));
IMPLEMENT_VOID_WRAPPER( glDetachShader , (GLuint program, GLuint shader), (program, shader));
IMPLEMENT_VOID_WRAPPER( glDisable , (GLenum cap), (cap));
IMPLEMENT_VOID_WRAPPER( glDisableVertexAttribArray , (GLuint index), (index));
IMPLEMENT_VOID_WRAPPER( glDrawArrays , (GLenum mode, GLint first, GLsizei count), (mode, first, count));
IMPLEMENT_VOID_WRAPPER( glDrawElements , (GLenum mode, GLsizei count, GLenum type, const GLvoid* indices), (mode, count, type, indices));
IMPLEMENT_VOID_WRAPPER( glEnable , (GLenum cap), (cap));
IMPLEMENT_VOID_WRAPPER( glEnableVertexAttribArray , (GLuint index), (index));
IMPLEMENT_VOID_WRAPPER( glFinish , (void), ());
IMPLEMENT_VOID_WRAPPER( glFlush , (void), ());
IMPLEMENT_VOID_WRAPPER( glFramebufferRenderbuffer , (GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer), (target, attachment, renderbuffertarget, renderbuffer));
IMPLEMENT_VOID_WRAPPER( glFramebufferTexture2D , (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level), (target, attachment, textarget, texture, level));
IMPLEMENT_VOID_WRAPPER( glFrontFace , (GLenum mode), (mode));
IMPLEMENT_VOID_WRAPPER( glGenBuffers , (GLsizei n, GLuint* buffers), (n, buffers));
IMPLEMENT_VOID_WRAPPER( glGenerateMipmap , (GLenum target), (target));
IMPLEMENT_VOID_WRAPPER( glGenFramebuffers , (GLsizei n, GLuint* framebuffers), (n, framebuffers));
IMPLEMENT_VOID_WRAPPER( glGenRenderbuffers , (GLsizei n, GLuint* renderbuffers), (n, renderbuffers));
IMPLEMENT_VOID_WRAPPER( glGenTextures , (GLsizei n, GLuint* textures), (n, textures));
IMPLEMENT_VOID_WRAPPER( glGetActiveAttrib , (GLuint program, GLuint index, GLsizei bufsize, GLsizei* length, GLint* size, GLenum* type, GLchar* name), (program, index, bufsize, length, size, type, name));
IMPLEMENT_VOID_WRAPPER( glGetActiveUniform , (GLuint program, GLuint index, GLsizei bufsize, GLsizei* length, GLint* size, GLenum* type, GLchar* name), (program, index, bufsize, length, size, type, name));
IMPLEMENT_VOID_WRAPPER( glGetAttachedShaders , (GLuint program, GLsizei maxcount, GLsizei* count, GLuint* shaders), (program, maxcount, count, shaders));
IMPLEMENT_WRAPPER(int , glGetAttribLocation , (GLuint program, const GLchar* name), (program, name));
IMPLEMENT_VOID_WRAPPER( glGetBooleanv , (GLenum pname, GLboolean* params), (pname, params));
IMPLEMENT_VOID_WRAPPER( glGetBufferParameteriv , (GLenum target, GLenum pname, GLint* params), (target, pname, params));
IMPLEMENT_WRAPPER(GLenum , glGetError , (void), ());
IMPLEMENT_VOID_WRAPPER( glGetFloatv , (GLenum pname, GLfloat* params), (pname, params));
IMPLEMENT_VOID_WRAPPER( glGetFramebufferAttachmentParameteriv , (GLenum target, GLenum attachment, GLenum pname, GLint* params), (target, attachment, pname, params));
IMPLEMENT_VOID_WRAPPER( glGetIntegerv , (GLenum pname, GLint* params), (pname, params));
IMPLEMENT_VOID_WRAPPER( glGetProgramiv , (GLuint program, GLenum pname, GLint* params), (program, pname, params));
IMPLEMENT_VOID_WRAPPER( glGetProgramInfoLog , (GLuint program, GLsizei bufsize, GLsizei* length, GLchar* infolog), (program, bufsize, length, infolog));
IMPLEMENT_VOID_WRAPPER( glGetRenderbufferParameteriv , (GLenum target, GLenum pname, GLint* params), (target, pname, params));
IMPLEMENT_VOID_WRAPPER( glGetShaderiv , (GLuint shader, GLenum pname, GLint* params), (shader, pname, params));
IMPLEMENT_VOID_WRAPPER( glGetShaderInfoLog , (GLuint shader, GLsizei bufsize, GLsizei* length, GLchar* infolog), (shader, bufsize, length, infolog));
IMPLEMENT_VOID_WRAPPER( glGetShaderPrecisionFormat , (GLenum shadertype, GLenum precisiontype, GLint* range, GLint* precision), (shadertype, precisiontype, range, precision));
IMPLEMENT_VOID_WRAPPER( glGetShaderSource , (GLuint shader, GLsizei bufsize, GLsizei* length, GLchar* source), (shader, bufsize, length, source));
IMPLEMENT_WRAPPER(const GLubyte*, glGetString , (GLenum name), (name));
IMPLEMENT_VOID_WRAPPER( glGetTexParameterfv , (GLenum target, GLenum pname, GLfloat* params), (target, pname, params));
IMPLEMENT_VOID_WRAPPER( glGetTexParameteriv , (GLenum target, GLenum pname, GLint* params), (target, pname, params));
IMPLEMENT_VOID_WRAPPER( glGetUniformfv , (GLuint program, GLint location, GLfloat* params), (program, location, params));
IMPLEMENT_VOID_WRAPPER( glGetUniformiv , (GLuint program, GLint location, GLint* params), (program, location, params));
IMPLEMENT_WRAPPER(int , glGetUniformLocation , (GLuint program, const GLchar* name), (program, name));
IMPLEMENT_VOID_WRAPPER( glGetVertexAttribfv , (GLuint index, GLenum pname, GLfloat* params), (index, pname, params));
IMPLEMENT_VOID_WRAPPER( glGetVertexAttribiv , (GLuint index, GLenum pname, GLint* params), (index, pname, params));
IMPLEMENT_VOID_WRAPPER( glGetVertexAttribPointerv , (GLuint index, GLenum pname, GLvoid** pointer), (index, pname, pointer));
IMPLEMENT_VOID_WRAPPER( glHint , (GLenum target, GLenum mode), (target, mode));
IMPLEMENT_WRAPPER(GLboolean , glIsBuffer , (GLuint buffer), (buffer));
IMPLEMENT_WRAPPER(GLboolean , glIsEnabled , (GLenum cap), (cap));
IMPLEMENT_WRAPPER(GLboolean , glIsFramebuffer , (GLuint framebuffer), (framebuffer));
IMPLEMENT_WRAPPER(GLboolean , glIsProgram , (GLuint program), (program));
IMPLEMENT_WRAPPER(GLboolean , glIsRenderbuffer , (GLuint renderbuffer), (renderbuffer));
IMPLEMENT_WRAPPER(GLboolean , glIsShader , (GLuint shader), (shader));
IMPLEMENT_WRAPPER(GLboolean , glIsTexture , (GLuint texture), (texture));
IMPLEMENT_VOID_WRAPPER( glLineWidth , (GLfloat width), (width));
IMPLEMENT_VOID_WRAPPER( glLinkProgram , (GLuint program), (program));
IMPLEMENT_VOID_WRAPPER( glPixelStorei , (GLenum pname, GLint param), (pname, param));
IMPLEMENT_VOID_WRAPPER( glPolygonOffset , (GLfloat factor, GLfloat units), (factor, units));
IMPLEMENT_VOID_WRAPPER( glReadPixels , (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid* pixels), (x, y, width, height, format, type, pixels));
IMPLEMENT_VOID_WRAPPER( glReleaseShaderCompiler , (void), ());
IMPLEMENT_VOID_WRAPPER( glRenderbufferStorage , (GLenum target, GLenum internalformat, GLsizei width, GLsizei height), (target, internalformat, width, height));
IMPLEMENT_VOID_WRAPPER( glSampleCoverage , (GLclampf value, GLboolean invert), (value, invert));
IMPLEMENT_VOID_WRAPPER( glScissor , (GLint x, GLint y, GLsizei width, GLsizei height), (x, y, width, height));
IMPLEMENT_VOID_WRAPPER( glShaderBinary , (GLsizei n, const GLuint* shaders, GLenum binaryformat, const GLvoid* binary, GLsizei length), (n, shaders, binaryformat, binary, length));
IMPLEMENT_VOID_WRAPPER( glShaderSource , (GLuint shader, GLsizei count, const GLchar** string, const GLint* length), (shader, count, string, length));
IMPLEMENT_VOID_WRAPPER( glStencilFunc , (GLenum func, GLint ref, GLuint mask), (func, ref, mask));
IMPLEMENT_VOID_WRAPPER( glStencilFuncSeparate , (GLenum face, GLenum func, GLint ref, GLuint mask), (face, func, ref, mask));
IMPLEMENT_VOID_WRAPPER( glStencilMask , (GLuint mask), (mask));
IMPLEMENT_VOID_WRAPPER( glStencilMaskSeparate , (GLenum face, GLuint mask), (face, mask));
IMPLEMENT_VOID_WRAPPER( glStencilOp , (GLenum fail, GLenum zfail, GLenum zpass), (fail, zfail, zpass));
IMPLEMENT_VOID_WRAPPER( glStencilOpSeparate , (GLenum face, GLenum fail, GLenum zfail, GLenum zpass), (face, fail, zfail, zpass));
IMPLEMENT_VOID_WRAPPER( glTexImage2D , (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid* pixels), (target, level, internalformat, width, height, border, format, type, pixels));
IMPLEMENT_VOID_WRAPPER( glTexParameterf , (GLenum target, GLenum pname, GLfloat param), (target, pname, param));
IMPLEMENT_VOID_WRAPPER( glTexParameterfv , (GLenum target, GLenum pname, const GLfloat* params), (target, pname, params));
IMPLEMENT_VOID_WRAPPER( glTexParameteri , (GLenum target, GLenum pname, GLint param), (target, pname, param));
IMPLEMENT_VOID_WRAPPER( glTexParameteriv , (GLenum target, GLenum pname, const GLint* params), (target, pname, params));
IMPLEMENT_VOID_WRAPPER( glTexSubImage2D , (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid* pixels), (target, level, xoffset, yoffset, width, height, format, type, pixels));
IMPLEMENT_VOID_WRAPPER( glUniform1f , (GLint location, GLfloat x), (location, x));
IMPLEMENT_VOID_WRAPPER( glUniform1fv , (GLint location, GLsizei count, const GLfloat* v), (location, count, v));
IMPLEMENT_VOID_WRAPPER( glUniform1i , (GLint location, GLint x), (location, x));
IMPLEMENT_VOID_WRAPPER( glUniform1iv , (GLint location, GLsizei count, const GLint* v), (location, count, v));
IMPLEMENT_VOID_WRAPPER( glUniform2f , (GLint location, GLfloat x, GLfloat y), (location, x, y));
IMPLEMENT_VOID_WRAPPER( glUniform2fv , (GLint location, GLsizei count, const GLfloat* v), (location, count, v));
IMPLEMENT_VOID_WRAPPER( glUniform2i , (GLint location, GLint x, GLint y), (location, x, y));
IMPLEMENT_VOID_WRAPPER( glUniform2iv , (GLint location, GLsizei count, const GLint* v), (location, count, v));
IMPLEMENT_VOID_WRAPPER( glUniform3f , (GLint location, GLfloat x, GLfloat y, GLfloat z), (location, x, y, z));
IMPLEMENT_VOID_WRAPPER( glUniform3fv , (GLint location, GLsizei count, const GLfloat* v), (location, count, v));
IMPLEMENT_VOID_WRAPPER( glUniform3i , (GLint location, GLint x, GLint y, GLint z), (location, x, y, z));
IMPLEMENT_VOID_WRAPPER( glUniform3iv , (GLint location, GLsizei count, const GLint* v), (location, count, v));
IMPLEMENT_VOID_WRAPPER( glUniform4f , (GLint location, GLfloat x, GLfloat y, GLfloat z, GLfloat w), (location, x, y, z, w));
IMPLEMENT_VOID_WRAPPER( glUniform4fv , (GLint location, GLsizei count, const GLfloat* v), (location, count, v));
IMPLEMENT_VOID_WRAPPER( glUniform4i , (GLint location, GLint x, GLint y, GLint z, GLint w), (location, x, y, z, w));
IMPLEMENT_VOID_WRAPPER( glUniform4iv , (GLint location, GLsizei count, const GLint* v), (location, count, v));
IMPLEMENT_VOID_WRAPPER( glUniformMatrix2fv , (GLint location, GLsizei count, GLboolean transpose, const GLfloat* value), (location, count, transpose, value));
IMPLEMENT_VOID_WRAPPER( glUniformMatrix3fv , (GLint location, GLsizei count, GLboolean transpose, const GLfloat* value), (location, count, transpose, value));
IMPLEMENT_VOID_WRAPPER( glUniformMatrix4fv , (GLint location, GLsizei count, GLboolean transpose, const GLfloat* value), (location, count, transpose, value));
IMPLEMENT_VOID_WRAPPER( glUseProgram , (GLuint program), (program));
IMPLEMENT_VOID_WRAPPER( glValidateProgram , (GLuint program), (program));
IMPLEMENT_VOID_WRAPPER( glVertexAttrib1f , (GLuint indx, GLfloat x), (indx, x));
IMPLEMENT_VOID_WRAPPER( glVertexAttrib1fv , (GLuint indx, const GLfloat* values), (indx, values));
IMPLEMENT_VOID_WRAPPER( glVertexAttrib2f , (GLuint indx, GLfloat x, GLfloat y), (indx, x, y));
IMPLEMENT_VOID_WRAPPER( glVertexAttrib2fv , (GLuint indx, const GLfloat* values), (indx, values));
IMPLEMENT_VOID_WRAPPER( glVertexAttrib3f , (GLuint indx, GLfloat x, GLfloat y, GLfloat z), (indx, x, y, z));
IMPLEMENT_VOID_WRAPPER( glVertexAttrib3fv , (GLuint indx, const GLfloat* values), (indx, values));
IMPLEMENT_VOID_WRAPPER( glVertexAttrib4f , (GLuint indx, GLfloat x, GLfloat y, GLfloat z, GLfloat w), (indx, x, y, z, w));
IMPLEMENT_VOID_WRAPPER( glVertexAttrib4fv , (GLuint indx, const GLfloat* values), (indx, values));
IMPLEMENT_VOID_WRAPPER( glVertexAttribPointer , (GLuint indx, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid* ptr), (indx, size, type, normalized, stride, ptr));
IMPLEMENT_VOID_WRAPPER( glViewport , (GLint x, GLint y, GLsizei width, GLsizei height), (x, y, width, height));

#endif // PACKAGE_DYN_CREATE
