//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(GENIVI_FRAME_BUFFER_RENDER_TARGET_H)
#define GENIVI_FRAME_BUFFER_RENDER_TARGET_H

#include <CanderaPlatform/Device/Common/Internal/GDU/GduBaseRenderTarget.h>
#include <CanderaPlatform/Device/Common/Internal/GDU/GduRenderTarget3DAttachment.h>
#include <CanderaPlatform/Device/Common/Internal/GDU/GduImageSource3DAttachment.h>
#include <CanderaPlatform/Device/Common/Internal/GDU/GduRenderTarget2DAttachment.h>
#include <CanderaPlatform/Device/Common/Internal/GDU/GduImageSource2DAttachment.h>
#include <CanderaPlatform/Device/Common/Internal/GDU/GduImage2DFrameBuffer.h>
#include <CanderaPlatform/Device/Common/Internal/GDU/GduContext2DAttachment.h>
#include <CanderaPlatform/Device/Common/Internal/GDU/GduContextFromOwner.h>
#include <CanderaPlatform/Device/Common/Internal/GDU/GduSupport.h>
#include <CanderaPlatform/Device/Common/Internal/GDU/GduFrameBufferMeasurementAttachment.h>

#include <CanderaPlatform/Device/Common/OpenGLES/GlOwnedFrameBufferProperties.h>
#include <CanderaPlatform/Device/Common/Internal/GL/GlTextureFrameBuffer.h>
#include <CanderaPlatform/Device/Common/Internal/GL/GlFlushSync.h>

#include <CanderaPlatform/Device/Common/Internal/RenderDevice2DOver3D/Context2DOver3D.h>

#include <CanderaPlatform/Device/Common/Internal/EGL/EglContextDelegator.h>
#include <CanderaPlatform/Device/Genivi/GeniviFrameBufferProperties.h>

namespace Candera
{


namespace GeniviFrameBufferRenderTargetNameSpace
{

    // Use EglContextDelegator as a context provider for the render target.
    typedef EglContextDelegator ContextProvider;

    // Add owner to ContextProvider.
    typedef GduContextFromOwner<
        ContextProvider,
        GduSupport,
        GeniviFrameBufferProperties,
        GeniviFrameBufferProperties >
            OwnedContextProvider;

#ifdef CANDERA_2D_ENABLED
    // Prepare a frame buffer.
    // Start from a GlTextureFrameBuffer and add 2D Image capabilities.
    typedef GduImage2DFrameBuffer<
        GlTextureFrameBuffer,
        ContextProvider,
        GduSupport,
        GlFrameBufferProperties>
            FrameBuffer;
#else
    typedef GlTextureFrameBuffer FrameBuffer;
#endif //CANDERA_2D_ENABLED

    // Bind everything together to get a render target.
    // Do synchronization by finalizing. No synchronization needed between
    // 2D and 3D.
    typedef GduBaseRenderTarget<
        OwnedContextProvider,
        FrameBuffer,
        GeniviFrameBufferProperties,
        GlFlushSync,
        GduSupport>
            RenderTargetBase;

#ifdef CANDERA_2D_ENABLED
    // Attach a 2D component to the 3D context.
    // This binds a Context2DOver3D.
    // Needs properties so that it can retrieve the size for the
    // 2D context pixel level mapping.
    // This can be bound to the RenderTargetBase because the
    // FrameBuffer doesn't need to know about the 2D context.
    typedef GduContext2DAttachment<
        RenderTargetBase,
        GduSupport,
        GeniviFrameBufferProperties,
        Internal::Context2DOver3D>
            RenderTargetBase2D;
#else
    typedef RenderTargetBase RenderTargetBase2D;
#endif //CANDERA_2D_ENABLED

    // Add the required attachments.
    // This surface needs to support all 4.
    typedef GduImageSource3DAttachment<
        RenderTargetBase2D>
        RenderTargetImageSource3D;
    typedef GduRenderTarget3DAttachment<
        RenderTargetImageSource3D>
        RenderTarget3D;
#ifdef CANDERA_2D_ENABLED
    typedef GduImageSource2DAttachment<
        RenderTarget3D>
        RenderTargetImageSource;
    typedef GduRenderTarget2DAttachment<
        RenderTargetImageSource>
            RenderTarget;

#else
    typedef RenderTarget3D RenderTarget;
#endif //CANDERA_2D_ENABLED


typedef GduFrameBufferMeasurementAttachment<
      RenderTarget>
           MeasuredRenderTarget;

}

/** @addtogroup GeniviGDITarget
 *  @{
 */

/**
 * @brief GeniviFrameBufferRenderTarget represents a Genivi frame buffer object with dedicated interface to render into.
 *
 * This object can be used as ImageSource2D/3D and RenderTarget2D/3D. It is useful
 * for off-screen rendering. The interface for this is missing.
 * Note that this class should not be accessed directly by the application, instead the interface of
 * GeniviFrameBufferObject should be used.
 */
class GeniviFrameBufferRenderTarget : public GeniviFrameBufferRenderTargetNameSpace::MeasuredRenderTarget
{
};

/** @}*/ //end of GeniviGDI

}

#endif
