//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(GENIVI_EGL_DISPLAY_H)
#define GENIVI_EGL_DISPLAY_H

#include "GeniviDisplay.h"
#include <CanderaPlatform/Device/Genivi/Target/GeniviDevicePackageInterface.h> //"GeniviDevicePackageInterface.h"

namespace Candera
{

class GeniviEglDisplay
{
public:
    GeniviEglDisplay() : m_displayId(-1) {}

    EGLDisplay GetDisplay() const {
        GeniviDisplay* display = GeniviDevicePackageInterface::GetInstance().GetDisplay(m_displayId);
        return (display == 0) ? EGL_NO_DISPLAY : display->GetParameters().eglDisplay;
    }

    void Upload(Int displayId, const GduSupport& /*layer*/)
    {
        m_displayId = displayId;
    }

    void Unload()
    {
        m_displayId = -1;
    }

private:
    Int m_displayId;
};

}

#endif
