//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <CanderaPlatform/Device/Common/Base/DevicePackageInterface.h>
#include <CanderaPlatform/Device/Common/Base/RenderDevice2D.h>
#include <CanderaPlatform/Device/Common/Internal/Context2DFeeder.h>//<Context2DFeeder.h>

#include <CanderaPlatform/Device/Genivi/GeniviCommonDevicePackageInterface.h>//"GeniviCommonDevicePackageInterface.h"
#include <CanderaPlatform/Device/Genivi/GeniviGpuPerformanceDataProvider.h>//"GeniviGpuPerformanceDataProvider.h"
#include <CanderaPlatform/Device/Genivi/Target/ILM/GeniviTargetDisplay.h>//"GeniviTargetDisplay.h"

namespace Candera
{


bool GeniviDevicePackageInterface::CreateDisplay(Int displayId)
{
    if ((displayId < 0) || (displayId >= MaxDisplayCount)) {
        return false;
    }


    m_displays[displayId] = CANDERA_NEW(GeniviTargetDisplay)(displayId);
    bool result = false;
    if (m_displays[displayId] != 0) {
        result = true;
    }
    return result;
}

ContextHandle2D DevicePackageInterface::CreateRenderContext2D(const RenderTarget2D* renderTarget)
{
    FEATSTD_UNUSED(renderTarget);
    return 0;
}

void DevicePackageInterface::DestroyRenderContext2D(ContextHandle2D context)
{
    FEATSTD_UNUSED(context);
}

bool DevicePackageInterface::UpdateRenderContext2D(ContextHandle2D context)
{
    FEATSTD_UNUSED(context);
    return false;
}

ContextProvider3D* DevicePackageInterface::CreateDefaultContextProvider(ContextResourcePool& /*pool*/, void* /*display*/, void* /*config*/, void* /*surface*/, void* /*context*/)
{
    return 0;
}

void DevicePackageInterface::DestroyDefaultContextProvider(const ContextProvider3D* /*provider*/)
{
}
GpuPerformanceDataProvider* DevicePackageInterface::GetGpuPerformanceDataProvider()
{
    static GeniviGpuPerformanceDataProvider performanceDataProvider;
    return &performanceDataProvider;
}

void GeniviDevicePackageInterface::ApplyChanges()
{
}

}

