//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(GENIVI_FRAMEBUFFER_OBJECT_H)
#define GENIVI_FRAMEBUFFER_OBJECT_H

#include <CanderaPlatform/Device/Common/Base/GraphicDeviceUnitMetaInfo.h>

#include <CanderaPlatform/Device/Common/OpenGLES/GlOwnedFrameBufferProperties.h>

#include <CanderaPlatform/Device/Common/Internal/GDU/GduAttachment.h>
#include <CanderaPlatform/Device/Common/Internal/GDU/GduWrapperExposer.h>
#include <CanderaPlatform/Device/Common/Internal/GDU/GduWrapperRenderTarget2D.h>
#include <CanderaPlatform/Device/Common/Internal/GDU/GduWrapperImageSource2D.h>
#include <CanderaPlatform/Device/Common/Internal/GDU/GduWrapperImageSource3D.h>

#include <GeniviFrameBufferRenderTarget.h>
#include <GeniviDevicePackageDescriptor.h>
#include <CanderaPlatform/Device/Genivi/GeniviFrameBufferProperties.h>

namespace Candera
{

//GduBeginDefinition(GeniviFrameBufferObject)
//
//    GduBase(GeniviFrameBufferRenderTarget)
//    GduDescription("3D Off-Screen Render Target")
//
//    GduProperties(GeniviFrameBufferProperties)
//    GduTypeHandle(c_geniviFrameBufferObjectType)
//
//    GduBeginAttachments()
//        GduBaseAttachment(RenderTarget3D)
//        GduDefaultAttachment(RenderTarget2D)
//        GduDefaultAttachment(ImageSource2D)
//        GduDefaultAttachment(ImageSource3D)
//    GduEndAttachments()
//
//GduEndDefinition(GeniviFrameBufferObject)

namespace GeniviFrameBufferObjectNameSpace
{
    typedef GduBase <
        GeniviFrameBufferRenderTarget,
        GeniviFrameBufferProperties,
        GduSupport,
        GduProperties,
        c_geniviFrameBufferObjectType>
        SimpleBase;

    typedef GduAttachment <
        SimpleBase,
        GduWrapperExposer<GeniviFrameBufferRenderTarget, RenderTarget3D>,
        GduProperties>
        RTBase3D;

    typedef GduAttachment <
        RTBase3D,
        GduWrapperImageSource3D<GeniviFrameBufferRenderTarget>,
        GduProperties>
        RTBase;

#ifdef CANDERA_2D_ENABLED
    typedef GduAttachment <
        RTBase,
        GduWrapperRenderTarget2D<GeniviFrameBufferRenderTarget>,
        GduProperties>
        RTBase2D;

    typedef GduAttachment <
        RTBase2D,
        GduWrapperImageSource2D<GeniviFrameBufferRenderTarget>,
        GduProperties>
        Base;
#else
    FEATSTD_TYPEDEF_BASE(RTBase);
#endif //CANDERA_2D_ENABLED
}

/** @addtogroup GeniviGDI
 *  @{
 */
 
/**
 * @brief GeniviFrameBufferObject
 *
 * Supported properties:
 * - Candera::GeniviFrameBufferProperties (use GetProperties() on Candera::GeniviFrameBufferObject)
 **/
class GeniviFrameBufferObject :
    public GeniviFrameBufferObjectNameSpace::Base
{
    public:
        GeniviFrameBufferObject() {}

        /// @cond excluded from doxygen
        CdaGduDef(GeniviFrameBufferObject)
            CdaReadableName("Hybrid 2D/3D Off-Screen Surface")
            CdaDescription("This render target represents an off-screen surface. "
                           "Both 2D and 3D cameras can be linked to this render target type. "
                           "Typically used to render into textures. ")


            CdaGduProperties()
            CdaGduImportProperties(Properties, Candera::GeniviFrameBufferProperties, GetProperties())
            CdaGduPropertiesEnd()
        CdaGduDefEnd()
        /// @endcond

    private:

        // Disallow copies of GeniviFrameBufferObject objects.
        CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1704, Candera::GeniviFrameBufferObject::GeniviFrameBufferObject, CANDERA_LINT_REASON_INSTANCESOBTAINABLE)
        GeniviFrameBufferObject(const GeniviFrameBufferObject& /*rhs*/);
        GeniviFrameBufferObject& operator=(const GeniviFrameBufferObject& /*rhs*/);
};

/** @}*/ //end of GeniviGDI

}

#endif
