//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "GlTrace.h"
#include <CanderaPlatform/Device/Common/OpenGLES/GlTraceMapper.h>
#include <CanderaPlatform/Device/Common/OpenGLES/GlInclude.h>

namespace Candera {
    
    static GLenum g_glError = GL_NO_ERROR;
    bool CANDERA_DEVICE_PACKAGE_TRACE_CLASS(Gles)::WasLastErrorSet()
    {
        return (g_glError != GL_NO_ERROR);
    }
    bool CANDERA_DEVICE_PACKAGE_TRACE_CLASS(Gles)::IsErrorSet()
    {
#ifdef FEATSTD_GLERRORS_AND_EGLERRORS_ENABLED
        g_glError = glGetError();
#endif
        return WasLastErrorSet();
    }
    const Char* CANDERA_DEVICE_PACKAGE_TRACE_CLASS(Gles)::GetLastErrorText()
    {
#ifdef FEATSTD_GLERRORS_AND_EGLERRORS_ENABLED
        return GlTraceMapper::MapGlErrorToString(g_glError);
#else
        return 0;
#endif

    }
}
