//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(GRAPHIC_DEVICE_UNIT_TYPES_H)
#define GRAPHIC_DEVICE_UNIT_TYPES_H


/** @addtogroup CommonDevice
 *  @{
 */

#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(FrameBufferColorFormat)                      \
        ENUM_DATA_TYPE_ITEM(DisabledColorFormat)                      \
        ENUM_DATA_TYPE_ITEM(RgbaUnpackedColorFormat)                  \
        ENUM_DATA_TYPE_ITEM(RgbUnpackedColorFormat)                   \
        ENUM_DATA_TYPE_ITEM(Rgba4ColorFormat)                         \
        ENUM_DATA_TYPE_ITEM(Rgba5A1ColorFormat)                       \
        ENUM_DATA_TYPE_ITEM(Rgb565ColorFormat)                        \
        ENUM_DATA_TYPE_ITEM(LuminanceAlphaColorFormat)                \
        ENUM_DATA_TYPE_ITEM(LuminanceColorFormat)                     \
        ENUM_DATA_TYPE_ITEM(AlphaColorFormat)                         \
        ENUM_DATA_TYPE_ITEM(SrgbaColorFormat)                         \
        ENUM_DATA_TYPE_ITEM(Rgba10A2ColorFormat)                      \
    ENUM_DATA_TYPE_END(FrameBufferColorFormat)

#include <Candera/System/MetaInfo/EnumDataType.h>


#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(FrameBufferDepthFormat)                      \
        ENUM_DATA_TYPE_ITEM(DisabledDepthFormat)                      \
        ENUM_DATA_TYPE_ITEM(Depth16Format)                            \
        ENUM_DATA_TYPE_ITEM(Depth24Format)                            \
        ENUM_DATA_TYPE_ITEM(Depth32Format)                            \
    ENUM_DATA_TYPE_END(FrameBufferDepthFormat)

#include <Candera/System/MetaInfo/EnumDataType.h>


#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(FrameBufferStencilFormat)                    \
        ENUM_DATA_TYPE_ITEM(DisabledStencilFormat)                    \
        ENUM_DATA_TYPE_ITEM(Stencil8Format)                           \
    ENUM_DATA_TYPE_END(FrameBufferStencilFormat)

#include <Candera/System/MetaInfo/EnumDataType.h>
#include <CanderaPlatform/Device/Common/OpenGLES/GlInclude.h>

#include <Candera/EngineBase/Common/Bitmap.h>

namespace Candera
{

    /**
     * Convert the wrapping format to an Open GL format.
     * @param format Format used for Texture Frame Buffer Objects.
     * @return Format used for Open GL Texture creation.
     */
    GLenum FrameBufferColorFormatToGlesType(FrameBufferColorFormat format);
    /**
     * Convert the wrapping format to an Open GL type.
     * @param format Format used for Texture Frame Buffer Objects.
     * @return Type used for Open GL Texture creation.
     */
    GLenum FrameBufferColorFormatToGlesFormat(FrameBufferColorFormat format);

    /**
    * Convert the wrapping format to an Open GL type.
    * @param format Format used for Texture Frame Buffer Objects.
    * @return Type used for Open GL Texture creation.
    */
    GLenum FrameBufferColorFormatToGlesInternalFormat(FrameBufferColorFormat format);

    /**
     * Convert the wrapping format to a Candera::Bitmap::PixelFormat.
     * @param format Format used for Texture Frame Buffer Objects.
     * @return Format used for Candera::Bitmap creation.
     */
    Bitmap::PixelFormat FrameBufferColorFormatToBitmapPixelFormat(FrameBufferColorFormat format);

    /**
     * Determine the number of bits per pixel for a given wrapping format.
     * @param format Format used for Texture Frame Buffer Objects.
     * @return Number of bits per pixel.
     */
    UInt8 FrameBufferColorFormatBitsPerPixel(FrameBufferColorFormat format);

    /**
     * Convert the wrapping format to an Open GL format.
     * @param format Format used for Depth Render Buffers.
     * @return Format used for Open GL render buffer creation.
     */
    GLenum FrameBufferDepthFormatToGlesFormat(FrameBufferDepthFormat format);

     /**
     * Convert the wrapping format to a Candera::Bitmap pixelformat.
     * @param format Format used for Depth Render Buffers.
     * @return Format used for Candera::Bitmap creation.
     */
    Int FrameBufferDepthFormatToBitmapPixelFormat(FrameBufferDepthFormat format);

    /**
     * Convert the wrapping format to an Open GL format.
     * @param format Format used for Stencil Render Buffers.
     * @return Format used for Open GL render buffer creation.
     */
    GLenum FrameBufferStencilFormatToGlesFormat(FrameBufferStencilFormat format);

     /**
     * Convert the wrapping format to a Candera::Bitmap pixelformat.
     * @param format Format used for Stencil Render Buffers.
     * @return Format used for Candera::Bitmap creation.
     */
    Int FrameBufferStencilFormatToBitmapPixelFormat(FrameBufferStencilFormat format);

    /**
     * Convert the wrapping format to an Open GL format.
     * This is used for determining whether the depth buffer and stencil buffer can be merged
     * on the current platform.
     * @param dformat Format used for Depth Render Buffers.
     * @param sformat Format used for Stencil Render Buffers.
     * @return Format used for Open GL render buffer creation, or ~0 or GL_INVALID_ENUM if the feature is not supported.
     */
    GLenum FrameBufferDepthStencilFormatToGlesFormat(FrameBufferDepthFormat dformat, FrameBufferStencilFormat sformat);

    /**
     * Determine the closest format that matches the requirements (similar to eglChooseConfig).
     * @param red Number for bits requested for the Red Color Channel.
     * @param green Number for bits requested for the Green Color Channel.
     * @param blue Number for bits requested for the Blue Color Channel.
     * @param alpha Number for bits requested for the Alpha Color Channel.
     * @return Format used for Texture Frame Buffer Objects.
     */
    FrameBufferColorFormat RgbaToFrameBufferColorFormat(Int red, Int green, Int blue, Int alpha);

    /**
     * Determine the closest format that matches the requirements (similar to eglChooseConfig).
     * @param size Number for bits requested for each depth buffer entry.
     * @return Format used for Depth Render Buffers.
     */
    FrameBufferDepthFormat SizeToFrameBufferDepthFormat(Int size);

    /**
     * Determine the closest format that matches the requirements (similar to eglChooseConfig).
     * @param size Number for bits requested for each stencil buffer entry.
     * @return Format used for Stencil Render Buffers.
     */
    FrameBufferStencilFormat SizeToFrameBufferStencilFormat(Int size);
}

/** @}*/ //end of CommonDevice

#endif
